"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggSelect = void 0;
exports.createLabel = createLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _job_creator_context = require("../../../job_creator_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/agg_select/agg_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AggSelect = ({
  fields,
  changeHandler,
  selectedOptions,
  removeOptions
}) => {
  const {
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.duplicateDetectors);
  // create list of labels based on already selected detectors
  // so they can be removed from the dropdown list
  const removeLabels = removeOptions.map(createLabel);
  const {
    handleFieldStatsButtonClick,
    populatedFields
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => {
    const opts = [];
    fields.forEach(f => {
      const isEmpty = f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID ? false : !(populatedFields !== null && populatedFields !== void 0 && populatedFields.has(f.name));
      const aggOption = {
        isGroupLabel: true,
        key: f.name,
        searchableLabel: f.name,
        isEmpty,
        // @ts-ignore Purposefully passing label as element instead of string
        // for more robust rendering
        label: /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.FieldStatsInfoButton, {
          hideTrigger: f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID,
          isEmpty: isEmpty,
          field: f,
          label: f.name,
          onButtonClick: handleFieldStatsButtonClick,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 13
          }
        })
      };
      if (typeof f.aggs !== 'undefined' && f.aggs.length > 0) {
        opts.push(aggOption);
        f.aggs.forEach(a => {
          const label = `${a.title}(${f.name})`;
          if (removeLabels.includes(label) === true) return;
          if (a.dslName !== null) {
            const agg = {
              key: label,
              isEmpty,
              hideTrigger: true,
              isGroupLabel: false,
              label,
              agg: (0, _lodash.omit)(a, 'fields'),
              field: (0, _lodash.omit)(f, 'aggs')
            };
            opts.push(agg);
          }
        });
      }
    });
    return opts;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [handleFieldStatsButtonClick, fields, removeLabels, populatedFields === null || populatedFields === void 0 ? void 0 : populatedFields.size]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.duplicateDetectors);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: validation.message,
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardAggSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.aggSelect.ariaLabel', {
      defaultMessage: 'Select an aggregation'
    }),
    singleSelection: true,
    options: options,
    selectedOptions: selectedOptions,
    onChange: changeHandler,
    isClearable: false,
    isInvalid: validation.valid === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
};
exports.AggSelect = AggSelect;
function createLabel(pair) {
  return `${pair.agg.title}(${pair.field.name})`;
}