"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _wizard_nav = require("../wizard_nav");
var _job_id = require("./components/job_id");
var _job_description = require("./components/job_description");
var _groups = require("./components/groups");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _advanced_section = require("./components/advanced_section");
var _additional_section = require("./components/additional_section");
var _json_editor_flyout = require("../common/json_editor_flyout");
var _job_creator = require("../../../common/job_creator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/job_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobDetailsStep = ({
  setCurrentStep,
  isCurrentStep,
  advancedExpanded,
  setAdvancedExpanded,
  additionalExpanded,
  setAdditionalExpanded
}) => {
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _jobValidator$latestV, _jobValidator$latestV2;
    const active = jobValidator.jobId.valid && jobValidator.modelMemoryLimit.valid && jobValidator.groupIds.valid && ((_jobValidator$latestV = jobValidator.latestValidationResult.jobIdExists) === null || _jobValidator$latestV === void 0 ? void 0 : _jobValidator$latestV.valid) === true && ((_jobValidator$latestV2 = jobValidator.latestValidationResult.groupIdsExist) === null || _jobValidator$latestV2 === void 0 ? void 0 : _jobValidator$latestV2.valid) === true && jobValidator.validating === false;
    setNextActive(active);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_job_id.JobIdInput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_groups.GroupsInput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_job_description.JobDescriptionInput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_additional_section.AdditionalSection, {
    additionalExpanded: additionalExpanded,
    setAdditionalExpanded: setAdditionalExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_section.AdvancedSection, {
    advancedExpanded: advancedExpanded,
    setAdvancedExpanded: setAdvancedExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.PICK_FIELDS),
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.VALIDATION),
    nextActive: nextActive,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, (0, _job_creator.isAdvancedJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: false,
    jobEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE,
    datafeedEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }))));
};
exports.JobDetailsStep = JobDetailsStep;