"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlsSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _custom_urls_description = require("../../../../../../../../../components/custom_urls/custom_urls_description");
var _dashboard_service = require("../../../../../../../../../services/dashboard_service");
var _custom_urls = require("../../../../../../../../../components/custom_urls/custom_urls");
var _job_creator_context = require("../../../../../job_creator_context");
var _kibana = require("../../../../../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/additional_section/components/custom_urls/custom_urls_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomUrlsSelection = () => {
  var _jobCreator$customUrl;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docsUrl = docLinks.links.ml.customUrls;
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const setCustomUrls = customUrls => {
    jobCreator.customUrls = customUrls;
    jobCreatorUpdate();
  };
  const combinedJob = {
    ...jobCreator.jobConfig,
    datafeed_config: jobCreator.datafeedConfig
  };
  const dashboardService = (0, _dashboard_service.useDashboardService)();
  const description = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.customUrlsSelection.description",
    defaultMessage: "Provide links from anomalies to Kibana dashboards, Discover, or other web pages. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsUrl,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.jobDetailsStep.additionalSection.customUrlsSelection.learnMoreLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), [docsUrl]);
  return /*#__PURE__*/_react.default.createElement(_custom_urls_description.CustomUrlsDescription, {
    description: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrls, {
    job: combinedJob,
    jobCustomUrls: (_jobCreator$customUrl = jobCreator.customUrls) !== null && _jobCreator$customUrl !== void 0 ? _jobCreator$customUrl : [],
    setCustomUrls: setCustomUrls,
    editMode: "modal",
    dashboardService: dashboardService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.CustomUrlsSelection = CustomUrlsSelection;