"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityFilterStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityFilterStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    filterButton: (0, _react.css)({
      opacity: 0.5,
      width: euiTheme.size.base,
      height: euiTheme.size.base,
      transform: 'translateY(-1px)',
      '&:hover': {
        opacity: 1
      },
      '.euiIcon': {
        width: euiTheme.size.m,
        height: euiTheme.size.m,
        color: euiTheme.colors.textSubdued
      }
    })
  };
};
exports.useEntityFilterStyles = useEntityFilterStyles;