"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _advanced_step_form = require("./advanced_step_form");
var _advanced_step_details = require("./advanced_step_details");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/advanced_step/advanced_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedStep = ({
  actions,
  state,
  step,
  setCurrentStep,
  stepActivated
}) => {
  const showForm = step === _page.ANALYTICS_STEPS.ADVANCED;
  const showDetails = step !== _page.ANALYTICS_STEPS.ADVANCED && stepActivated === true;
  const dataTestSubj = `mlAnalyticsCreateJobWizardAdvancedStep${showForm ? ' active' : ''}${showDetails ? ' summary' : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, showForm && /*#__PURE__*/_react.default.createElement(_advanced_step_form.AdvancedStepForm, {
    actions: actions,
    state: state,
    setCurrentStep: setCurrentStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }), showDetails && /*#__PURE__*/_react.default.createElement(_advanced_step_details.AdvancedStepDetails, {
    setCurrentStep: setCurrentStep,
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 23
    }
  }));
};
exports.AdvancedStep = AdvancedStep;