"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VegaChartView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _vegaLite = require("vega-lite/build/vega-lite");
var _vega = require("vega");
var _vegaInterpreter = require("vega-interpreter");
var _vegaTooltip = require("vega-tooltip");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/vega_chart/vega_chart_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// There is still an issue with Vega Lite's typings with the strict mode Kibana is using.
// @ts-ignore
// There is still an issue with Vega Lite's typings with the strict mode Kibana is using.
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VegaChartView = ({
  vegaSpec
}) => {
  const htmlId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  (0, _react.useEffect)(() => {
    const vgSpec = (0, _vegaLite.compile)(vegaSpec).spec;
    const view = new _vega.View((0, _vega.parse)(vgSpec, undefined, {
      ast: true
    }), {
      expr: _vegaInterpreter.expressionInterpreter
    }).logLevel(_vega.Warn).renderer('canvas').tooltip(new _vegaTooltip.Handler().call).initialize(`#${htmlId}`);
    view.runAsync(); // evaluate and render the view
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [vegaSpec]);
  return /*#__PURE__*/_react.default.createElement("div", {
    id: htmlId,
    className: "mlVegaChart",
    "data-test-subj": "mlVegaChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  });
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.VegaChartView = VegaChartView;
var _default = exports.default = VegaChartView;