"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineHorizontalSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../ml_inference/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/shared/add_inference_pipeline_horizontal_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const steps = Object.values(_constants.ADD_INFERENCE_PIPELINE_STEPS);
const DISABLED = 'disabled';
const COMPLETE = 'complete';
const INCOMPLETE = 'incomplete';
const AddInferencePipelineHorizontalSteps = exports.AddInferencePipelineHorizontalSteps = /*#__PURE__*/(0, _react.memo)(({
  step,
  setStep,
  isDetailsStepValid,
  isConfigureProcessorStepValid,
  hasProcessorStep,
  pipelineCreated
}) => {
  const currentStepIndex = steps.findIndex(s => s === step);
  const navSteps = [{
    // Details
    onClick: () => {
      if (pipelineCreated) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS);
    },
    status: isDetailsStepValid ? COMPLETE : INCOMPLETE,
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.details.title', {
      defaultMessage: 'Details'
    })
  }, {
    // Handle failures
    onClick: () => {
      if (!isDetailsStepValid || pipelineCreated) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE);
    },
    status: currentStepIndex > 2 ? COMPLETE : INCOMPLETE,
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.handleFailures.title', {
      defaultMessage: 'Handle failures'
    })
  }, {
    // Test
    onClick: () => {
      if (!isConfigureProcessorStepValid || !isDetailsStepValid || pipelineCreated) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.TEST);
    },
    status: currentStepIndex > 3 ? COMPLETE : INCOMPLETE,
    title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.transforms.addInferencePipelineModal.steps.test.title', {
      defaultMessage: 'Test (Optional)'
    })
  }, {
    // Review and Create
    onClick: () => {
      if (!isConfigureProcessorStepValid || pipelineCreated) return;
      setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE);
    },
    status: isDetailsStepValid && isConfigureProcessorStepValid ? INCOMPLETE : DISABLED,
    title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.create.title', {
      defaultMessage: 'Create'
    })
  }];
  if (hasProcessorStep === true) {
    navSteps.splice(1, 0, {
      // Processor configuration
      onClick: () => {
        if (!isDetailsStepValid || pipelineCreated) return;
        setStep(_constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR);
      },
      status: isDetailsStepValid && isConfigureProcessorStepValid && currentStepIndex > 1 ? COMPLETE : INCOMPLETE,
      title: _i18n.i18n.translate('xpack.ml.inferencePipeline.content.indices.transforms.addInferencePipelineModal.steps.configureProcessor.title', {
        defaultMessage: 'Configure processor'
      })
    });
  }
  let DETAILS_INDEX;
  let CONFIGURE_INDEX;
  let ON_FAILURE_INDEX;
  let TEST_INDEX;
  let CREATE_INDEX;
  if (hasProcessorStep) {
    [DETAILS_INDEX, CONFIGURE_INDEX, ON_FAILURE_INDEX, TEST_INDEX, CREATE_INDEX] = [0, 1, 2, 3, 4, 5];
  } else {
    [DETAILS_INDEX, ON_FAILURE_INDEX, TEST_INDEX, CREATE_INDEX] = [0, 1, 2, 3, 4];
  }
  switch (step) {
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS:
      navSteps[DETAILS_INDEX].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR:
      if (CONFIGURE_INDEX !== undefined) {
        navSteps[CONFIGURE_INDEX].status = 'current';
      }
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE:
      navSteps[ON_FAILURE_INDEX].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST:
      navSteps[TEST_INDEX].status = 'current';
      break;
    case _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE:
      navSteps[CREATE_INDEX].status = 'current';
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: navSteps,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 12
    }
  });
});