"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScatterplotFieldOptions = void 0;
var _react = require("react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useScatterplotFieldOptions = (indexPattern, includes, excludes, resultsField = '') => {
  return (0, _react.useMemo)(() => {
    const fields = [];
    if (indexPattern === undefined || includes === undefined) {
      return fields;
    }
    if (includes.length > 1) {
      fields.push(...includes.filter(d => indexPattern.fields.some(f => f.name === d && f.type === 'number')));
    } else {
      fields.push(...indexPattern.fields.filter(f => f.type === 'number' && !indexPattern.metaFields.includes(f.name) && !f.name.startsWith(`${resultsField}.`) && f.name !== _mlDataFrameAnalyticsUtils.ML__INCREMENTAL_ID).map(f => f.name));
    }
    return Array.isArray(excludes) && excludes.length > 0 ? fields.filter(f => !excludes.includes(f)) : fields;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexPattern, includes, excludes]);
};
exports.useScatterplotFieldOptions = useScatterplotFieldOptions;