"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditModelSnapshotFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/model_snapshots/edit_model_snapshot_flyout/edit_model_snapshot_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditModelSnapshotFlyout = ({
  snapshot,
  job,
  closeFlyout
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const [description, setDescription] = (0, _react.useState)(snapshot.description);
  const [retain, setRetain] = (0, _react.useState)(snapshot.retain);
  const [deleteModalVisible, setDeleteModalVisible] = (0, _react.useState)(false);
  const [isCurrentSnapshot, setIsCurrentSnapshot] = (0, _react.useState)(snapshot.snapshot_id === job.model_snapshot_id);
  (0, _react.useEffect)(() => {
    setIsCurrentSnapshot(snapshot.snapshot_id === job.model_snapshot_id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [snapshot]);
  const updateSnapshot = (0, _react.useCallback)(async () => {
    try {
      await mlApi.updateModelSnapshot(snapshot.job_id, snapshot.snapshot_id, {
        description,
        retain
      });
      closeWithReload();
    } catch (error) {
      toasts.addError(new Error(error.body.message), {
        title: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.saveErrorTitle', {
          defaultMessage: 'Model snapshot update failed'
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [retain, description, snapshot]);
  const deleteSnapshot = (0, _react.useCallback)(async () => {
    try {
      await mlApi.deleteModelSnapshot(snapshot.job_id, snapshot.snapshot_id);
      hideDeleteModal();
      closeWithReload();
    } catch (error) {
      toasts.addError(new Error(error.body.message), {
        title: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.deleteErrorTitle', {
          defaultMessage: 'Model snapshot deletion failed'
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [snapshot]);
  function closeWithReload() {
    closeFlyout(true);
  }
  function closeWithoutReload() {
    closeFlyout(false);
  }
  function showDeleteModal() {
    setDeleteModalVisible(true);
  }
  function hideDeleteModal() {
    setDeleteModalVisible(false);
  }
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'editModelSnapshotFlyout'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeWithoutReload,
    hideCloseButton: true,
    size: "m",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.editModelSnapshotFlyout.title",
    defaultMessage: "Edit snapshot {ssId}",
    values: {
      ssId: snapshot.snapshot_id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }))), isCurrentSnapshot && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.calloutTitle', {
      defaultMessage: 'Current snapshot'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.editModelSnapshotFlyout.calloutText",
    defaultMessage: "This is the current snapshot being used by job {jobId} and so cannot be deleted.",
    values: {
      jobId: job.job_id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: description,
    onChange: e => setDescription(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.retainSwitchLabel', {
      defaultMessage: 'Retain snapshot during automatic snapshot cleanup process'
    }),
    checked: retain,
    onChange: e => setRetain(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeWithoutReload,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.editModelSnapshotFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: showDeleteModal,
    color: "danger",
    disabled: isCurrentSnapshot === true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.editModelSnapshotFlyout.useDefaultButton",
    defaultMessage: "Delete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: updateSnapshot,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.editModelSnapshotFlyout.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 17
    }
  })))))), deleteModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.deleteTitle', {
      defaultMessage: 'Delete snapshot?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: hideDeleteModal,
    onConfirm: deleteSnapshot,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.editModelSnapshotFlyout.deleteButton', {
      defaultMessage: 'Delete'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }));
};
exports.EditModelSnapshotFlyout = EditModelSnapshotFlyout;