"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSpacesSyncFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _sync_list = require("./sync_list");
var _toast_notification_service = require("../../services/toast_notification_service");
var _sync_to_all_spaces_warning = require("./sync_to_all_spaces_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_spaces_sync/job_spaces_sync_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobSpacesSyncFlyout = ({
  onClose
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [loading, setLoading] = (0, _react.useState)(false);
  const [canSync, setCanSync] = (0, _react.useState)(false);
  const [canSyncToAllSpaces, setCanSyncToAllSpaces] = (0, _react.useState)(true);
  const [syncResp, setSyncResp] = (0, _react.useState)(null);
  const {
    savedObjects: {
      syncSavedObjects,
      canSyncToAllSpaces: canSyncToAllSpacesFunc
    }
  } = (0, _kibana.useMlApi)();
  async function loadSyncList(simulate = true) {
    setLoading(true);
    try {
      const resp = await syncSavedObjects(simulate, canSyncToAllSpaces);
      setSyncResp(resp);
      if (simulate === true) {
        setCanSyncToAllSpaces((await canSyncToAllSpacesFunc()).canSync);
      }
      const count = Object.values(resp).reduce((acc, cur) => acc + Object.keys(cur).length, 0);
      setCanSync(count > 0);
      setLoading(false);
      return resp;
    } catch (error) {
      // this shouldn't be hit as errors are returned per-sync task
      // as part of the response
      displayErrorToast(error);
      setLoading(false);
    }
    return null;
  }
  (0, _react.useEffect)(() => {
    loadSyncList();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function sync() {
    if (canSync) {
      // perform the sync
      const resp = await loadSyncList(false);
      // check simulate the sync again to check that all
      // items have been synchronized.
      await loadSyncList(true);
      if (resp === null) {
        return;
      }
      const {
        successCount,
        errorCount
      } = getResponseCounts(resp);
      if (errorCount > 0) {
        const title = _i18n.i18n.translate('xpack.ml.management.syncSavedObjectsFlyout.sync.error', {
          defaultMessage: 'Some jobs or trained models cannot be synchronized.'
        });
        displayErrorToast(resp, title);
        return;
      }
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.management.syncSavedObjectsFlyout.sync.success', {
        defaultMessage: '{successCount} {successCount, plural, one {item} other {items}} synchronized',
        values: {
          successCount
        }
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 600,
    onClose: onClose,
    "data-test-subj": "mlJobMgmtSyncFlyout",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.headerLabel",
    defaultMessage: "Synchronize saved objects",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.description",
    defaultMessage: "Synchronize the saved objects if they are out of sync with the machine learning jobs in Elasticsearch.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }))), canSyncToAllSpaces === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sync_to_all_spaces_warning.SyncToAllSpacesWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sync_list.SyncList, {
    syncItems: syncResp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "mlJobMgmtSyncFlyoutCloseButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: sync,
    fill: true,
    isDisabled: canSync === false || loading === true,
    "data-test-subj": "mlJobMgmtSyncFlyoutSyncButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.syncButton",
    defaultMessage: "Synchronize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  })))))));
};
exports.JobSpacesSyncFlyout = JobSpacesSyncFlyout;
function getResponseCounts(resp) {
  let successCount = 0;
  let errorCount = 0;
  Object.values(resp).forEach(result => {
    Object.values(result).forEach(type => {
      Object.values(type).forEach(({
        success,
        error
      }) => {
        if (success === true) {
          successCount++;
        } else if (error !== undefined) {
          errorCount++;
        }
      });
    });
  });
  return {
    successCount,
    errorCount
  };
}