"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _entity_cell_styles = require("./entity_cell_styles");
var _entity_control = require("../../timeseriesexplorer/components/entity_control/entity_control");
var _component_utils = require("../../util/component_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/entity_cell/entity_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddFilter = ({
  entityName,
  entityValue,
  filter
}) => {
  const {
    filterButton
  } = (0, _entity_cell_styles.useEntityCellStyles)();
  if (filter === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.entityCell.addFilterTooltip",
      defaultMessage: "Add filter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    "data-test-subj": `mlAnomaliesTableEntityCellAddFilterButton-${entityValue}`,
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      filter(entityName, entityValue, _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD);
    }),
    iconType: "plusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.entityCell.addFilterAriaLabel', {
      defaultMessage: 'Add filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
const RemoveFilter = ({
  entityName,
  entityValue,
  filter
}) => {
  const {
    filterButton
  } = (0, _entity_cell_styles.useEntityCellStyles)();
  if (filter === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomaliesTable.entityCell.removeFilterTooltip",
      defaultMessage: "Remove filter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    "data-test-subj": `mlAnomaliesTableEntityCellRemoveFilterButton-${entityValue}`,
    css: filterButton,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      filter(entityName, entityValue, _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.REMOVE);
    }),
    iconType: "minusInCircle",
    "aria-label": _i18n.i18n.translate('xpack.ml.anomaliesTable.entityCell.removeFilterAriaLabel', {
      defaultMessage: 'Remove filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};

/*
 * Component for rendering an entity, displaying the value
 * of the entity, such as a partitioning or influencer field value, and optionally links for
 * adding or removing a filter on this entity.
 */
const EntityCell = ({
  entityName,
  entityValue,
  filter,
  wrapText = false
}) => {
  let valueText = entityValue === '' ? /*#__PURE__*/_react.default.createElement("i", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 40
    }
  }, _entity_control.EMPTY_FIELD_VALUE_LABEL) : entityValue;
  if (entityName === _mlAnomalyUtils.MLCATEGORY) {
    valueText = `${_mlAnomalyUtils.MLCATEGORY} ${valueText}`;
  }
  const {
    fieldValueShort,
    fieldValueLong
  } = (0, _entity_cell_styles.useEntityCellStyles)();
  const textStyle = {
    maxWidth: '100%'
  };
  const textWrapperCss = wrapText ? fieldValueLong : fieldValueShort;
  const shouldDisplayIcons = filter !== undefined && entityName !== undefined && entityValue !== undefined;
  if (wrapText === true) {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: textWrapperCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, valueText), shouldDisplayIcons && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AddFilter, {
      entityName: entityName,
      entityValue: entityValue,
      filter: filter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(RemoveFilter, {
      entityName: entityName,
      entityValue: entityValue,
      filter: filter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: textStyle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: textWrapperCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, valueText)), shouldDisplayIcons && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(AddFilter, {
      entityName: entityName,
      entityValue: entityValue,
      filter: filter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(RemoveFilter, {
      entityName: entityName,
      entityValue: entityValue,
      filter: filter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    })))));
  }
};
exports.EntityCell = EntityCell;