"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ordinalColorStop = exports.lineColorSchema = exports.labelColorSchema = exports.labelBorderColorSchema = exports.fillColorSchema = exports.colorStaticSchema = exports.colorStaticOptions = exports.colorSchema = exports.colorDynamicSchema = exports.colorDynamicOptions = exports.categoryColorStop = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../../../common/constants");
var _vector_style_schemas = require("./vector_style_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categoryColorStop = exports.categoryColorStop = _configSchema.schema.object({
  stop: _configSchema.schema.nullable(_configSchema.schema.string()),
  color: _configSchema.schema.string()
});
const ordinalColorStop = exports.ordinalColorStop = _configSchema.schema.object({
  stop: _configSchema.schema.number(),
  color: _configSchema.schema.string()
});
const colorDynamicOptions = exports.colorDynamicOptions = _configSchema.schema.object({
  // ordinal color properties
  color: _configSchema.schema.maybe(_configSchema.schema.string()),
  customColorRamp: _configSchema.schema.maybe(_configSchema.schema.arrayOf(ordinalColorStop)),
  useCustomColorRamp: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  dataMappingFunction: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.DATA_MAPPING_FUNCTION.INTERPOLATE), _configSchema.schema.literal(_constants.DATA_MAPPING_FUNCTION.PERCENTILES)])),
  invert: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // category color properties
  colorCategory: _configSchema.schema.maybe(_configSchema.schema.string()),
  customColorPalette: _configSchema.schema.maybe(_configSchema.schema.arrayOf(categoryColorStop)),
  useCustomColorPalette: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  otherCategoryColor: _configSchema.schema.maybe(_configSchema.schema.string()),
  field: _configSchema.schema.maybe(_vector_style_schemas.styleField),
  fieldMetaOptions: _vector_style_schemas.fieldMetaOptions,
  type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.COLOR_MAP_TYPE.CATEGORICAL), _configSchema.schema.literal(_constants.COLOR_MAP_TYPE.ORDINAL)]))
});
const colorStaticOptions = exports.colorStaticOptions = _configSchema.schema.object({
  color: _configSchema.schema.string()
});
const colorStaticSchema = exports.colorStaticSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.STATIC),
  options: colorStaticOptions
});
const colorDynamicSchema = exports.colorDynamicSchema = _configSchema.schema.object({
  type: _configSchema.schema.literal(_constants.STYLE_TYPE.DYNAMIC),
  options: colorDynamicOptions
});
const colorSchema = exports.colorSchema = _configSchema.schema.oneOf([colorStaticSchema, colorDynamicSchema]);
const fillColorSchema = exports.fillColorSchema = _configSchema.schema.oneOf([colorStaticSchema, colorDynamicSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      color: '#16C5C0'
    }
  },
  meta: {
    description: 'Configure to set feature filled color. Line features do not have filled area and are not effected by this configuration.'
  }
});
const lineColorSchema = exports.lineColorSchema = _configSchema.schema.oneOf([colorStaticSchema, colorDynamicSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      color: '#16C5C0'
    }
  },
  meta: {
    description: 'Configure to set feature border color. Ignored when border size is 0'
  }
});
const labelColorSchema = exports.labelColorSchema = _configSchema.schema.oneOf([colorStaticSchema, colorDynamicSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      color: '#000000'
    }
  },
  meta: {
    description: 'Configure to set label text color'
  }
});
const labelBorderColorSchema = exports.labelBorderColorSchema = _configSchema.schema.oneOf([colorStaticSchema, colorDynamicSchema], {
  defaultValue: {
    type: _constants.STYLE_TYPE.STATIC,
    options: {
      color: '#FFFFFF'
    }
  },
  meta: {
    description: 'Configure to set label border color'
  }
});