"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapsListView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
var _content_management = require("../../content_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/routes/list_page/maps_list_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
function navigateToNewMap() {
  var _getUsageCollection;
  const navigateToApp = (0, _kibana_services.getNavigateToApp)();
  (_getUsageCollection = (0, _kibana_services.getUsageCollection)()) === null || _getUsageCollection === void 0 ? void 0 : _getUsageCollection.reportUiCounter(_constants.APP_ID, _analytics.METRIC_TYPE.CLICK, 'create_maps_vis_editor');
  navigateToApp(_constants.APP_ID, {
    path: _constants.MAP_PATH
  });
}
const toTableListViewSavedObject = mapItem => {
  var _mapItem$attributes$t;
  return {
    ...mapItem,
    updatedAt: mapItem.updatedAt,
    attributes: {
      ...mapItem.attributes,
      title: (_mapItem$attributes$t = mapItem.attributes.title) !== null && _mapItem$attributes$t !== void 0 ? _mapItem$attributes$t : ''
    }
  };
};
async function deleteMaps(items) {
  await Promise.all(items.map(({
    id
  }) => (0, _content_management.getMapClient)().delete(id)));
}
function MapsListViewComp({
  history
}) {
  (0, _kibana_services.getExecutionContextService)().set({
    type: 'application',
    name: _constants.APP_ID,
    page: 'list'
  });
  const isReadOnly = !(0, _kibana_services.getMapsCapabilities)().save;
  const initialPageSize = (0, _kibana_services.getUiSettings)().get(SAVED_OBJECTS_PER_PAGE_SETTING);

  // TLDR; render should be side effect free
  //
  // setBreadcrumbs fires observables which cause state changes in ScreenReaderRouteAnnouncements.
  // wrap chrome updates in useEffect to avoid potentially causing state changes in other component during render phase.
  (0, _react.useEffect)(() => {
    (0, _kibana_services.getCoreChrome)().docTitle.change(_constants.APP_NAME);
    if ((0, _kibana_services.getServerless)()) {
      (0, _kibana_services.getServerless)().setBreadcrumbs({
        text: _constants.APP_NAME
      });
    } else {
      (0, _kibana_services.getCoreChrome)().setBreadcrumbs([{
        text: _constants.APP_NAME
      }]);
    }
  }, []);
  const findMaps = (0, _react.useCallback)(async (searchTerm, {
    references = [],
    referencesToExclude = []
  } = {}) => {
    return (0, _content_management.getMapClient)().search({
      text: searchTerm ? `${searchTerm}*` : undefined,
      limit: (0, _kibana_services.getUiSettings)().get(SAVED_OBJECTS_LIMIT_SETTING),
      tags: {
        included: references.map(({
          id
        }) => id),
        excluded: referencesToExclude.map(({
          id
        }) => id)
      }
    }).then(({
      hits,
      pagination: {
        total
      }
    }) => {
      return {
        total,
        hits: hits.map(toTableListViewSavedObject)
      };
    }).catch(e => {
      return {
        total: 0,
        hits: []
      };
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, {
    id: "map",
    headingId: "mapsListingPage",
    createItem: isReadOnly ? undefined : navigateToNewMap,
    findItems: findMaps,
    deleteItems: isReadOnly ? undefined : deleteMaps,
    initialFilter: '',
    initialPageSize: initialPageSize,
    entityName: _i18n.i18n.translate('xpack.maps.mapListing.entityName', {
      defaultMessage: 'map'
    }),
    entityNamePlural: _i18n.i18n.translate('xpack.maps.mapListing.entityNamePlural', {
      defaultMessage: 'maps'
    }),
    title: _constants.APP_NAME,
    getOnClickTitle: ({
      id
    }) => () => history.push((0, _constants.getEditPath)(id)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
}
const MapsListView = exports.MapsListView = /*#__PURE__*/(0, _react.memo)(MapsListViewComp);