"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SymbolIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _symbol_utils = require("../../symbol_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/legend/symbol_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class SymbolIcon extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      imgDataUrl: null
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadSymbol();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadSymbol() {
    let imgDataUrl;
    try {
      const styledSvg = await (0, _symbol_utils.styleSvg)(this.props.svg, this.props.fill, this.props.stroke);
      imgDataUrl = (0, _symbol_utils.buildSrcUrl)(styledSvg);
    } catch (error) {
      // ignore failures - component will just not display an icon
      return;
    }
    if (this._isMounted) {
      this.setState({
        imgDataUrl
      });
    }
  }
  render() {
    if (!this.state.imgDataUrl) {
      return null;
    }
    const {
      symbolId,
      fill,
      stroke,
      ...rest
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
      width: "16px",
      height: "18px",
      src: this.state.imgDataUrl,
      alt: this.props.symbolId
    }, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }));
  }
}
exports.SymbolIcon = SymbolIcon;