"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapStyle = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _heatmap_style_editor = require("./components/heatmap_style_editor");
var _heatmap_legend = require("./components/legend/heatmap_legend");
var _color_palettes = require("../color_palettes");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/heatmap/heatmap_style.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// The heatmap range chosen hear runs from 0 to 1. It is arbitrary.
// Weighting is on the raw count/sum values.
const MIN_RANGE = 0.1; // 0 to 0.1 is displayed as transparent color stop
const MAX_RANGE = 1;
class HeatmapStyle {
  constructor(descriptor = {
    colorRampName: _color_palettes.DEFAULT_HEATMAP_COLOR_RAMP_NAME
  }) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = HeatmapStyle.createDescriptor(descriptor.colorRampName);
  }
  static createDescriptor(colorRampName) {
    return {
      type: _constants.LAYER_STYLE_TYPE.HEATMAP,
      colorRampName: colorRampName ? colorRampName : _color_palettes.DEFAULT_HEATMAP_COLOR_RAMP_NAME
    };
  }
  getType() {
    return _constants.LAYER_STYLE_TYPE.HEATMAP;
  }
  renderEditor(onStyleDescriptorChange) {
    const onHeatmapColorChange = ({
      colorRampName
    }) => {
      const styleDescriptor = HeatmapStyle.createDescriptor(colorRampName);
      onStyleDescriptorChange(styleDescriptor);
    };
    return /*#__PURE__*/_react.default.createElement(_heatmap_style_editor.HeatmapStyleEditor, {
      colorRampName: this._descriptor.colorRampName,
      onHeatmapColorChange: onHeatmapColorChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    });
  }
  renderLegendDetails(field) {
    return /*#__PURE__*/_react.default.createElement(_heatmap_legend.HeatmapLegend, {
      colorRampName: this._descriptor.colorRampName,
      field: field,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    });
  }
  getIcon() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "heatmap",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  setMBPaintProperties({
    mbMap,
    layerId,
    propertyName,
    max,
    resolution
  }) {
    let radius;
    if (resolution === _constants.GRID_RESOLUTION.COARSE) {
      radius = 128;
    } else if (resolution === _constants.GRID_RESOLUTION.FINE) {
      radius = 64;
    } else if (resolution === _constants.GRID_RESOLUTION.MOST_FINE) {
      radius = 32;
    } else {
      radius = 8;
    }
    mbMap.setPaintProperty(layerId, 'heatmap-radius', radius);
    if (max <= 0) {
      mbMap.setPaintProperty(layerId, 'heatmap-weight', 0);
    } else {
      mbMap.setPaintProperty(layerId, 'heatmap-weight', ['/', ['get', propertyName], max]);
    }
    const colorStops = (0, _color_palettes.getOrdinalMbColorRampStops)(this._descriptor.colorRampName, MIN_RANGE, MAX_RANGE, false);
    if (colorStops) {
      mbMap.setPaintProperty(layerId, 'heatmap-color', ['interpolate', ['linear'], ['heatmap-density'], 0, 'rgba(0, 0, 255, 0)', ...colorStops]);
    }
  }
}
exports.HeatmapStyle = HeatmapStyle;