"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityLayerWizardConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _security_index_pattern_utils = require("./security_index_pattern_utils");
var _security_layer_template = require("./security_layer_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/security/security_layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SecurityLayerWizardConfig = exports.SecurityLayerWizardConfig = {
  id: _constants.WIZARD_ID.SECURITY,
  order: 20,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH, _constants.LAYER_WIZARD_CATEGORY.SOLUTIONS],
  getIsDisabled: async () => {
    const indexPatterns = await (0, _security_index_pattern_utils.getSecurityIndexPatterns)();
    return indexPatterns.length === 0;
  },
  disabledReason: _i18n.i18n.translate('xpack.maps.security.disabledDesc', {
    defaultMessage: 'Cannot find security data view. To get started with Security, go to Security > Overview.'
  }),
  description: _i18n.i18n.translate('xpack.maps.security.desc', {
    defaultMessage: 'Security layers'
  }),
  icon: 'logoSecurity',
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_security_layer_template.SecurityLayerTemplate, (0, _extends2.default)({}, renderWizardArguments, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 12
      }
    }));
  },
  title: _i18n.i18n.translate('xpack.maps.security.title', {
    defaultMessage: 'Security'
  })
};