"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnToOperation = columnToOperation;
Object.defineProperty(exports, "deleteColumn", {
  enumerable: true,
  get: function () {
    return _operations.deleteColumn;
  }
});
exports.getFormBasedDatasource = getFormBasedDatasource;
Object.defineProperty(exports, "getSuffixFormatter", {
  enumerable: true,
  get: function () {
    return _suffix_formatter.getSuffixFormatter;
  }
});
exports.removeColumn = void 0;
Object.defineProperty(exports, "suffixFormatterId", {
  enumerable: true,
  get: function () {
    return _suffix_formatter.suffixFormatterId;
  }
});
Object.defineProperty(exports, "unitSuffixesLong", {
  enumerable: true,
  get: function () {
    return _suffix_formatter.unitSuffixesLong;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _loader = require("./loader");
var _to_expression = require("./to_expression");
var _dimension_panel = require("./dimension_panel");
var _datapanel = require("./datapanel");
var _form_based_suggestions = require("./form_based_suggestions");
var _utils = require("./utils");
var _utils2 = require("../../utils");
var _pure_utils = require("./pure_utils");
var _layerpanel = require("./layerpanel");
var _operations = require("./operations");
var _layer_helpers = require("./operations/layer_helpers");
var _state_helpers = require("./state_helpers");
var _geo_field_workspace_panel = require("../../editor_frame_service/editor_frame/workspace_panel/geo_field_workspace_panel");
var _time_shift_utils = require("./time_shift_utils");
var _constants = require("../../../common/constants");
var _helpers = require("./operations/definitions/helpers");
var _layer_settings = require("./layer_settings");
var _get_application_user_messages = require("../../app_plugin/get_application_user_messages");
var _user_messages_ids = require("../../user_messages_ids");
var _user_messages_utils = require("../../user_messages_utils");
var _suffix_formatter = require("../../../common/suffix_formatter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/form_based.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function wrapOnDot(str) {
  // u200B is a non-width white-space character, which allows
  // the browser to efficiently word-wrap right after the dot
  // without us having to draw a lot of extra DOM elements, etc
  return str ? str.replace(/\./g, '.\u200B') : '';
}
const getSelectedFieldsFromColumns = (0, _memoizeOne.default)(columns => columns.flatMap(c => {
  var _operationDefinitionM;
  if ((_operationDefinitionM = _operations.operationDefinitionMap[c.operationType]) !== null && _operationDefinitionM !== void 0 && _operationDefinitionM.getCurrentFields) {
    var _operationDefinitionM2, _operationDefinitionM3;
    return ((_operationDefinitionM2 = _operations.operationDefinitionMap[c.operationType]) === null || _operationDefinitionM2 === void 0 ? void 0 : (_operationDefinitionM3 = _operationDefinitionM2.getCurrentFields) === null || _operationDefinitionM3 === void 0 ? void 0 : _operationDefinitionM3.call(_operationDefinitionM2, c)) || [];
  } else if ('sourceField' in c) {
    return c.sourceField;
  }
}).filter(_utils2.nonNullable), _lodash.isEqual);
function getSortingHint(column, dataView) {
  if (column.dataType === 'string') {
    var _dataView$getFieldByN;
    const fieldTypes = 'sourceField' in column ? dataView === null || dataView === void 0 ? void 0 : (_dataView$getFieldByN = dataView.getFieldByName(column.sourceField)) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.esTypes : undefined;
    return (fieldTypes === null || fieldTypes === void 0 ? void 0 : fieldTypes[0]) || undefined;
  }
  if ((0, _helpers.isColumnOfType)('last_value', column)) {
    return column.dataType;
  }
}
const removeColumn = ({
  prevState,
  layerId,
  columnId,
  indexPatterns
}) => {
  var _prevState$layers$lay;
  const indexPattern = indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns[(_prevState$layers$lay = prevState.layers[layerId]) === null || _prevState$layers$lay === void 0 ? void 0 : _prevState$layers$lay.indexPatternId];
  if (!indexPattern) {
    throw new Error('indexPatterns is not passed to the function');
  }
  return (0, _state_helpers.mergeLayer)({
    state: prevState,
    layerId,
    newLayer: (0, _operations.deleteColumn)({
      layer: prevState.layers[layerId],
      columnId,
      indexPattern
    })
  });
};
exports.removeColumn = removeColumn;
function columnToOperation(column, uniqueLabel, dataView) {
  const {
    dataType,
    label,
    isBucketed,
    operationType,
    timeShift,
    reducedTimeRange
  } = column;
  const operationDefinition = _operations.operationDefinitionMap[operationType];
  if (!operationDefinition) {
    throw new Error(_i18n.i18n.translate('xpack.lens.indexPattern.operationNotFoundErrorMessage', {
      defaultMessage: 'Operation {operationType} not found',
      values: {
        operationType
      }
    }));
  }
  const scale = operationDefinition.scale ? operationDefinition.scale(column, dataView) : 'ratio';
  return {
    dataType: (0, _pure_utils.normalizeOperationDataType)(dataType),
    isBucketed,
    scale,
    label: uniqueLabel || label,
    isStaticValue: operationType === 'static_value',
    sortingHint: getSortingHint(column, dataView),
    hasTimeShift: Boolean(timeShift),
    hasReducedTimeRange: Boolean(reducedTimeRange),
    interval: (0, _helpers.isColumnOfType)('date_histogram', column) ? column.params.interval : undefined,
    hasArraySupport: (0, _helpers.isColumnOfType)('last_value', column) && column.params.showArrayValues
  };
}
function getFormBasedDatasource({
  core,
  storage,
  data,
  unifiedSearch,
  share,
  dataViews,
  fieldFormats,
  charts,
  dataViewFieldEditor,
  uiActions
}) {
  const {
    uiSettings,
    featureFlags
  } = core;
  const DATASOURCE_ID = 'formBased';
  const ALIAS_IDS = ['indexpattern'];

  // Not stateful. State is persisted to the frame
  const formBasedDatasource = {
    id: DATASOURCE_ID,
    alias: ALIAS_IDS,
    initialize(persistedState, references, initialContext, indexPatternRefs, indexPatterns, dateRange) {
      return (0, _loader.loadInitialState)({
        persistedState,
        references,
        defaultIndexPatternId: uiSettings.get('defaultIndex'),
        storage,
        initialContext,
        indexPatternRefs,
        indexPatterns,
        dateRange
      });
    },
    getPersistableState(state) {
      const {
        references,
        state: persistableState
      } = (0, _loader.extractReferences)(state);
      const newPersistableState = (0, _helpers.cleanupFormulaColumns)(persistableState);
      return {
        references,
        state: newPersistableState
      };
    },
    insertLayer(state, newLayerId, linkToLayers) {
      return {
        ...state,
        layers: {
          ...state.layers,
          [newLayerId]: blankLayer(state.currentIndexPatternId, linkToLayers)
        }
      };
    },
    createEmptyLayer(indexPatternId) {
      return {
        currentIndexPatternId: indexPatternId,
        layers: {}
      };
    },
    cloneLayer(state, layerId, newLayerId, getNewId) {
      return {
        ...state,
        layers: (0, _utils.cloneLayer)(state.layers, layerId, newLayerId, getNewId)
      };
    },
    removeLayer(state, layerId) {
      const newLayers = {
        ...state.layers
      };
      delete newLayers[layerId];
      const removedLayerIds = [layerId];

      // delete layers linked to this layer
      Object.keys(newLayers).forEach(id => {
        var _newLayers$id;
        const linkedLayers = (_newLayers$id = newLayers[id]) === null || _newLayers$id === void 0 ? void 0 : _newLayers$id.linkToLayers;
        if (linkedLayers && linkedLayers.includes(layerId)) {
          delete newLayers[id];
          removedLayerIds.push(id);
        }
      });
      return {
        removedLayerIds,
        newState: {
          ...state,
          layers: newLayers
        }
      };
    },
    clearLayer(state, layerId) {
      var _state$layers$layerId;
      const newLayers = {
        ...state.layers
      };
      const removedLayerIds = [];
      // delete layers linked to this layer
      Object.keys(newLayers).forEach(id => {
        var _newLayers$id2;
        const linkedLayers = (_newLayers$id2 = newLayers[id]) === null || _newLayers$id2 === void 0 ? void 0 : _newLayers$id2.linkToLayers;
        if (linkedLayers && linkedLayers.includes(layerId)) {
          delete newLayers[id];
          removedLayerIds.push(id);
        }
      });
      return {
        removedLayerIds,
        newState: {
          ...state,
          layers: {
            ...newLayers,
            [layerId]: blankLayer(state.currentIndexPatternId, (_state$layers$layerId = state.layers[layerId]) === null || _state$layers$layerId === void 0 ? void 0 : _state$layers$layerId.linkToLayers)
          }
        }
      };
    },
    getLayers(state) {
      return Object.keys(state === null || state === void 0 ? void 0 : state.layers);
    },
    removeColumn,
    initializeDimension(state, layerId, indexPatterns, {
      columnId,
      groupId,
      staticValue,
      autoTimeField,
      visualizationGroups
    }) {
      var _state$layers$layerId2;
      const indexPattern = indexPatterns[(_state$layers$layerId2 = state.layers[layerId]) === null || _state$layers$layerId2 === void 0 ? void 0 : _state$layers$layerId2.indexPatternId];
      let ret = state;
      if (staticValue != null) {
        ret = (0, _state_helpers.mergeLayer)({
          state,
          layerId,
          newLayer: (0, _operations.insertNewColumn)({
            layer: state.layers[layerId],
            op: 'static_value',
            columnId,
            field: undefined,
            indexPattern,
            visualizationGroups,
            initialParams: {
              params: {
                value: staticValue
              }
            },
            targetGroup: groupId
          })
        });
      }
      if (autoTimeField && indexPattern.timeFieldName) {
        ret = (0, _state_helpers.mergeLayer)({
          state,
          layerId,
          newLayer: (0, _operations.insertNewColumn)({
            layer: state.layers[layerId],
            op: 'date_histogram',
            columnId,
            field: indexPattern.fields.find(field => field.name === indexPattern.timeFieldName),
            indexPattern,
            visualizationGroups,
            targetGroup: groupId
          })
        });
      }
      return ret;
    },
    syncColumns({
      state,
      links,
      indexPatterns,
      getDimensionGroups
    }) {
      let modifiedLayers = state.layers;
      links.forEach(link => {
        var _modifiedLayers$link$, _modifiedLayers$link$2;
        const source = {
          ...link.from,
          dataView: indexPatterns[(_modifiedLayers$link$ = modifiedLayers[link.from.layerId]) === null || _modifiedLayers$link$ === void 0 ? void 0 : _modifiedLayers$link$.indexPatternId],
          filterOperations: () => true
        };
        const target = {
          ...link.to,
          dataView: indexPatterns[(_modifiedLayers$link$2 = modifiedLayers[link.to.layerId]) === null || _modifiedLayers$link$2 === void 0 ? void 0 : _modifiedLayers$link$2.indexPatternId],
          filterOperations: () => true
        };
        modifiedLayers = (0, _layer_helpers.copyColumn)({
          layers: modifiedLayers,
          target,
          source
        });
        const updatedColumnOrder = (0, _layer_helpers.reorderByGroups)(getDimensionGroups(target.layerId), (0, _layer_helpers.getColumnOrder)(modifiedLayers[target.layerId]), target.groupId, target.columnId);
        modifiedLayers = {
          ...modifiedLayers,
          [target.layerId]: {
            ...modifiedLayers[target.layerId],
            columnOrder: updatedColumnOrder,
            columns: modifiedLayers[target.layerId].columns
          }
        };
      });
      const newState = (0, _state_helpers.mergeLayers)({
        state,
        newLayers: modifiedLayers
      });
      links.filter(link => (0, _helpers.isColumnOfType)('terms', newState.layers[link.from.layerId].columns[link.from.columnId])).forEach(({
        from,
        to
      }) => {
        const fromColumn = newState.layers[from.layerId].columns[from.columnId];
        if (fromColumn.params.orderBy.type === 'column') {
          const fromOrderByColumnId = fromColumn.params.orderBy.columnId;
          const orderByColumnLink = links.find(({
            from: {
              columnId
            }
          }) => columnId === fromOrderByColumnId);
          if (orderByColumnLink) {
            // order the synced column by the dimension which is linked to the column that the original column was ordered by
            const toColumn = newState.layers[to.layerId].columns[to.columnId];
            toColumn.params.orderBy = {
              type: 'column',
              columnId: orderByColumnLink.to.columnId
            };
          }
        }
      });
      return newState;
    },
    getSelectedFields(state) {
      var _Object$values;
      return getSelectedFieldsFromColumns((_Object$values = Object.values(state === null || state === void 0 ? void 0 : state.layers)) === null || _Object$values === void 0 ? void 0 : _Object$values.flatMap(l => Object.values(l.columns)));
    },
    toExpression: (state, layerId, indexPatterns, dateRange, nowInstant, searchSessionId, forceDSL) => (0, _to_expression.toExpression)(state, layerId, indexPatterns, uiSettings, featureFlags, dateRange, nowInstant, searchSessionId, forceDSL),
    LayerSettingsComponent(props) {
      return /*#__PURE__*/_react.default.createElement(_layer_settings.LayerSettingsPanel, (0, _extends2.default)({}, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 505,
          columnNumber: 14
        }
      }));
    },
    DataPanelComponent(props) {
      var _formBasedDatasource$;
      const {
        onChangeIndexPattern,
        ...otherProps
      } = props;
      const layerFields = formBasedDatasource === null || formBasedDatasource === void 0 ? void 0 : (_formBasedDatasource$ = formBasedDatasource.getSelectedFields) === null || _formBasedDatasource$ === void 0 ? void 0 : _formBasedDatasource$.call(formBasedDatasource, props.state);
      return /*#__PURE__*/_react.default.createElement(_datapanel.FormBasedDataPanel, (0, _extends2.default)({
        data: data,
        dataViews: dataViews,
        fieldFormats: fieldFormats,
        charts: charts,
        indexPatternFieldEditor: dataViewFieldEditor
      }, otherProps, {
        core: core,
        uiActions: uiActions,
        onIndexPatternRefresh: _loader.onRefreshIndexPattern,
        layerFields: layerFields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 511,
          columnNumber: 9
        }
      }));
    },
    uniqueLabels(state, indexPatternsMap) {
      const layers = state.layers;
      const columnLabelMap = {};
      const uniqueLabelGenerator = (0, _utils2.getUniqueLabelGenerator)();
      Object.values(layers).forEach(layer => {
        if (!layer.columns) {
          return;
        }
        Object.entries(layer.columns).forEach(([columnId, column]) => {
          columnLabelMap[columnId] = uniqueLabelGenerator(column.customLabel ? column.label : _operations.operationDefinitionMap[column.operationType].getDefaultLabel(column, layer.columns, indexPatternsMap[layer.indexPatternId]));
        });
      });
      return columnLabelMap;
    },
    DimensionTriggerComponent: props => {
      const columnLabelMap = formBasedDatasource.uniqueLabels(props.state, props.indexPatterns);
      const uniqueLabel = columnLabelMap[props.columnId];
      const formattedLabel = wrapOnDot(uniqueLabel);
      return /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DimensionTrigger, {
        id: props.columnId,
        label: formattedLabel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 556,
          columnNumber: 14
        }
      });
    },
    DimensionEditorComponent: props => {
      const columnLabelMap = formBasedDatasource.uniqueLabels(props.state, props.indexPatterns);
      return /*#__PURE__*/_react.default.createElement(_dimension_panel.FormBasedDimensionEditor, (0, _extends2.default)({
        uiSettings: uiSettings,
        storage: storage,
        fieldFormats: fieldFormats,
        http: core.http,
        data: data,
        unifiedSearch: unifiedSearch,
        dataViews: dataViews,
        uniqueLabel: columnLabelMap[props.columnId],
        notifications: core.notifications
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 563,
          columnNumber: 9
        }
      }));
    },
    LayerPanelComponent: props => {
      const {
        onChangeIndexPattern,
        ...otherProps
      } = props;
      return /*#__PURE__*/_react.default.createElement(_layerpanel.LayerPanel, (0, _extends2.default)({
        onChangeIndexPattern: indexPatternId => {
          (0, _loader.triggerActionOnIndexPatternChange)({
            indexPatternId,
            state: props.state,
            layerId: props.layerId,
            uiActions
          });
          onChangeIndexPattern(indexPatternId, DATASOURCE_ID, props.layerId);
        }
      }, otherProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 581,
          columnNumber: 9
        }
      }));
    },
    getDropProps: _dimension_panel.getDropProps,
    onDrop: _dimension_panel.onDrop,
    getCustomWorkspaceRenderer: (state, dragging, indexPatterns) => {
      if (dragging.field === undefined || dragging.indexPatternId === undefined) {
        return undefined;
      }
      const indexPattern = indexPatterns[dragging.indexPatternId];
      const draggedField = dragging;
      const geoFieldType = draggedField.field.esTypes && draggedField.field.esTypes.find(esType => {
        return ['geo_point', 'geo_shape'].includes(esType);
      });
      return geoFieldType ? () => {
        return /*#__PURE__*/_react.default.createElement(_geo_field_workspace_panel.GeoFieldWorkspacePanel, {
          uiActions: uiActions,
          fieldType: geoFieldType,
          indexPattern: indexPattern,
          fieldName: draggedField.field.name,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 621,
            columnNumber: 15
          }
        });
      } : undefined;
    },
    updateCurrentIndexPatternId: ({
      state,
      indexPatternId,
      setState
    }) => {
      setState({
        ...state,
        currentIndexPatternId: indexPatternId
      });
    },
    onRefreshIndexPattern: _loader.onRefreshIndexPattern,
    onIndexPatternChange(state, indexPatterns, indexPatternId, layerId) {
      if (layerId) {
        const layersToChange = [layerId, ...Object.entries(state.layers).map(([possiblyLinkedId, layer]) => {
          var _layer$linkToLayers;
          return (_layer$linkToLayers = layer.linkToLayers) !== null && _layer$linkToLayers !== void 0 && _layer$linkToLayers.includes(layerId) ? possiblyLinkedId : '';
        }).filter(Boolean)];
        return (0, _loader.changeLayerIndexPattern)({
          indexPatternId,
          layerIds: layersToChange,
          state,
          replaceIfPossible: true,
          storage,
          indexPatterns
        });
      }
      return (0, _loader.changeIndexPattern)({
        indexPatternId,
        state,
        storage,
        indexPatterns
      });
    },
    onIndexPatternRename: (state, oldIndexPatternId, newIndexPatternId) => {
      return (0, _loader.renameIndexPattern)({
        state,
        oldIndexPatternId,
        newIndexPatternId
      });
    },
    getRenderEventCounters(state) {
      var _state$layers;
      const additionalEvents = {
        time_shift: false,
        filter: false
      };
      const operations = (0, _lodash.flatten)(Object.values((_state$layers = state === null || state === void 0 ? void 0 : state.layers) !== null && _state$layers !== void 0 ? _state$layers : {}).map(l => Object.values(l.columns).map(c => {
        if (c.timeShift) {
          additionalEvents.time_shift = true;
        }
        if (c.filter) {
          additionalEvents.filter = true;
        }
        return c.operationType;
      })));
      return [...operations, ...Object.entries(additionalEvents).reduce((acc, [key, isActive]) => {
        if (isActive) {
          acc.push(key);
        }
        return acc;
      }, [])].map(item => `dimension_${item}`);
    },
    // Reset the temporary invalid state when closing the editor, but don't
    // update the state if it's not needed
    updateStateOnCloseDimension: ({
      state,
      layerId
    }) => {
      const layer = state.layers[layerId];
      if (!Object.values(layer.incompleteColumns || {}).length) {
        return;
      }
      return (0, _state_helpers.mergeLayer)({
        state,
        layerId,
        newLayer: {
          ...layer,
          incompleteColumns: undefined
        }
      });
    },
    getPublicAPI({
      state,
      layerId,
      indexPatterns
    }) {
      const columnLabelMap = formBasedDatasource.uniqueLabels(state, indexPatterns);
      const layer = state.layers[layerId];
      const visibleColumnIds = layer.columnOrder.filter(colId => !(0, _operations.isReferenced)(layer, colId));
      return {
        datasourceId: DATASOURCE_ID,
        datasourceAliasIds: ALIAS_IDS,
        getTableSpec: () => {
          // consider also referenced columns in this case
          // but map fields to the top referencing column
          const fieldsPerColumn = {};
          Object.keys(layer.columns).forEach(colId => {
            const visibleColumnId = (0, _layer_helpers.getReferenceRoot)(layer, colId);
            fieldsPerColumn[visibleColumnId] = fieldsPerColumn[visibleColumnId] || [];
            const column = layer.columns[colId];
            if ((0, _helpers.isColumnOfType)('terms', column)) {
              var _column$params$second;
              fieldsPerColumn[visibleColumnId].push(...[column.sourceField].concat((_column$params$second = column.params.secondaryFields) !== null && _column$params$second !== void 0 ? _column$params$second : []));
            }
            if ('sourceField' in column && column.sourceField !== _constants.DOCUMENT_FIELD_NAME) {
              fieldsPerColumn[visibleColumnId].push(column.sourceField);
            }
          });
          return visibleColumnIds.map((colId, i) => ({
            columnId: colId,
            fields: [...new Set(fieldsPerColumn[colId] || [])]
          }));
        },
        isTextBasedLanguage: () => false,
        getOperationForColumnId: columnId => {
          if (layer && layer.columns[columnId]) {
            if (!(0, _operations.isReferenced)(layer, columnId)) {
              return columnToOperation(layer.columns[columnId], columnLabelMap[columnId], indexPatterns[layer.indexPatternId]);
            }
          }
          return null;
        },
        getSourceId: () => {
          return layer.indexPatternId;
        },
        getFilters: (activeData, timeRange) => {
          return (0, _utils.getFiltersInLayer)(layer, visibleColumnIds, activeData === null || activeData === void 0 ? void 0 : activeData[layerId], indexPatterns[layer.indexPatternId], timeRange);
        },
        getVisualDefaults: () => (0, _utils.getVisualDefaultsForLayer)(layer),
        getMaxPossibleNumValues: columnId => {
          if (layer && layer.columns[columnId]) {
            var _operationDefinitionM4, _operationDefinitionM5, _operationDefinitionM6;
            const column = layer.columns[columnId];
            return (_operationDefinitionM4 = (_operationDefinitionM5 = (_operationDefinitionM6 = _operations.operationDefinitionMap[column.operationType]).getMaxPossibleNumValues) === null || _operationDefinitionM5 === void 0 ? void 0 : _operationDefinitionM5.call(_operationDefinitionM6, column)) !== null && _operationDefinitionM4 !== void 0 ? _operationDefinitionM4 : null;
          }
          return null;
        },
        hasDefaultTimeField: () => Boolean(indexPatterns[layer.indexPatternId].timeFieldName)
      };
    },
    getDatasourceSuggestionsForField(state, draggedField, filterLayers, indexPatterns) {
      return (0, _utils2.isDraggedDataViewField)(draggedField) ? (0, _form_based_suggestions.getDatasourceSuggestionsForField)(state, draggedField.indexPatternId, draggedField.field, indexPatterns, filterLayers) : [];
    },
    getDatasourceSuggestionsFromCurrentState: _form_based_suggestions.getDatasourceSuggestionsFromCurrentState,
    getDatasourceSuggestionsForVisualizeField: _form_based_suggestions.getDatasourceSuggestionsForVisualizeField,
    getDatasourceSuggestionsForVisualizeCharts: _form_based_suggestions.getDatasourceSuggestionsForVisualizeCharts,
    getUserMessages(state, {
      frame: framePublicAPI,
      setState,
      visualizationInfo
    }) {
      if (!state) {
        return [];
      }
      const layerErrorMessages = getLayerErrorMessages(state, framePublicAPI, setState, core, data);
      const dimensionErrorMessages = getInvalidDimensionErrorMessages(state, layerErrorMessages, (layerId, columnId) => {
        const layer = state.layers[layerId];
        const column = layer.columns[columnId];
        const indexPattern = framePublicAPI.dataViews.indexPatterns[layer.indexPatternId];
        if (!column || !indexPattern) {
          // this is a different issue that should be catched earlier
          return false;
        }
        return (0, _utils.isColumnInvalid)(layer, column, columnId, indexPattern, framePublicAPI.dateRange, uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET));
      });
      const timeShiftWarningMessages = (0, _time_shift_utils.getStateTimeShiftWarningMessages)(data.datatableUtilities, state, framePublicAPI);
      const precisionErrorWarningMsg = (0, _utils.getPrecisionErrorWarningMessages)(data.datatableUtilities, state, framePublicAPI, core.docLinks, setState);
      const unsupportedOpsWarningMsg = (0, _utils.getUnsupportedOperationsWarningMessage)(state, framePublicAPI, core.docLinks);
      const infoMessages = (0, _utils.getNotifiableFeatures)(state, framePublicAPI, visualizationInfo);
      return layerErrorMessages.concat(dimensionErrorMessages, timeShiftWarningMessages, precisionErrorWarningMsg, unsupportedOpsWarningMsg, infoMessages);
    },
    getSearchWarningMessages: (state, warning, request, response) => {
      return (0, _utils.getSearchWarningMessages)(state, warning, request, response, core.theme);
    },
    checkIntegrity: (state, indexPatterns) => {
      const ids = Object.values(state.layers || {}).map(({
        indexPatternId
      }) => indexPatternId);
      return ids.filter(id => !indexPatterns[id]);
    },
    isTimeBased: (state, indexPatterns) => {
      if (!state) return false;
      const {
        layers
      } = state;
      return Boolean(layers) && Object.values(layers).some(layer => {
        var _indexPatterns$layer$;
        return Boolean((_indexPatterns$layer$ = indexPatterns[layer.indexPatternId]) === null || _indexPatterns$layer$ === void 0 ? void 0 : _indexPatterns$layer$.timeFieldName) || layer.columnOrder.filter(colId => layer.columns[colId].isBucketed).some(colId => {
          const column = layer.columns[colId];
          return (0, _helpers.isColumnOfType)('date_histogram', column) && !column.params.ignoreTimeRange;
        });
      });
    },
    isEqual: (persistableState1, references1, persistableState2, references2) => (0, _lodash.isEqual)((0, _loader.injectReferences)(persistableState1, references1), (0, _loader.injectReferences)(persistableState2, references2)),
    getUsedDataView: (state, layerId) => {
      if (!layerId) {
        return state.currentIndexPatternId;
      }
      return state.layers[layerId].indexPatternId;
    },
    getUsedDataViews: state => {
      return Object.values(state.layers).map(({
        indexPatternId
      }) => indexPatternId);
    },
    injectReferencesToLayers: (state, references) => {
      const layers = references && state ? (0, _loader.injectReferences)(state, references).layers : state === null || state === void 0 ? void 0 : state.layers;
      return {
        ...state,
        layers
      };
    },
    getDatasourceInfo: async (state, references, dataViewsService) => {
      const layers = references ? (0, _loader.injectReferences)(state, references).layers : state.layers;
      const indexPatterns = await Promise.all(Object.values(layers).map(({
        indexPatternId
      }) => dataViewsService === null || dataViewsService === void 0 ? void 0 : dataViewsService.get(indexPatternId)).filter(_utils2.nonNullable));
      return Object.entries(layers).reduce((acc, [key, layer]) => {
        const dataView = indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.find(indexPattern => indexPattern.id === layer.indexPatternId);
        const columns = Object.entries(layer.columns).map(([colId, col]) => {
          const fields = (0, _pure_utils.hasField)(col) ? (0, _operations.getCurrentFieldsForOperation)(col) : undefined;
          return {
            id: colId,
            role: col.isBucketed ? 'split' : 'metric',
            operation: {
              ...columnToOperation(col, undefined, dataView),
              type: col.operationType,
              fields,
              filter: col.filter
            }
          };
        });
        acc.push({
          layerId: key,
          columns,
          dataView
        });
        return acc;
      }, []);
    }
  };
  return formBasedDatasource;
}
function blankLayer(indexPatternId, linkToLayers) {
  return {
    indexPatternId,
    linkToLayers,
    columns: {},
    columnOrder: [],
    sampling: 1,
    ignoreGlobalFilters: false
  };
}
function getLayerErrorMessages(state, framePublicAPI, setState, core, data) {
  const indexPatterns = framePublicAPI.dataViews.indexPatterns;
  const layerErrors = Object.entries(state.layers).filter(([_, layer]) => !!indexPatterns[layer.indexPatternId]).map(([layerId, layer]) => {
    var _getErrorMessages;
    return ((_getErrorMessages = (0, _operations.getErrorMessages)(layer, indexPatterns[layer.indexPatternId], state, layerId, core, data)) !== null && _getErrorMessages !== void 0 ? _getErrorMessages : []).map(error => {
      var _error$fixAction2;
      const message = {
        uniqueId: typeof error === 'string' ? error : error.uniqueId,
        severity: 'error',
        fixableInEditor: true,
        displayLocations: typeof error !== 'string' && error.displayLocations ? error.displayLocations : [{
          id: 'visualization'
        }],
        shortMessage: '',
        longMessage: typeof error === 'string' ? error : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.message, error.fixAction && setState && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          "data-test-subj": "errorFixAction",
          onClick: async () => {
            var _error$fixAction;
            const newState = await ((_error$fixAction = error.fixAction) === null || _error$fixAction === void 0 ? void 0 : _error$fixAction.newState(framePublicAPI));
            if (newState) {
              setState(newState);
            }
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 993,
            columnNumber: 19
          }
        }, (_error$fixAction2 = error.fixAction) === null || _error$fixAction2 === void 0 ? void 0 : _error$fixAction2.label))
      };
      return message;
    });
  });
  let errorMessages;
  if (layerErrors.length <= 1) {
    var _layerErrors$;
    // Single layer case, no need to explain more
    errorMessages = (_layerErrors$ = layerErrors[0]) !== null && _layerErrors$ !== void 0 && _layerErrors$.length ? layerErrors[0] : [];
  } else {
    errorMessages = layerErrors.flatMap((errors, index) => {
      return errors.map(error => {
        // we will prepend each error with the layer number
        if (error.displayLocations.find(location => location.id === 'visualization')) {
          const message = {
            ...error,
            shortMessage: _i18n.i18n.translate('xpack.lens.indexPattern.layerErrorWrapper', {
              defaultMessage: 'Layer {position} error: {wrappedMessage}',
              values: {
                position: index + 1,
                wrappedMessage: error.shortMessage
              }
            }),
            longMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.lens.indexPattern.layerErrorWrapper",
              defaultMessage: "Layer {position} error: {wrappedMessage}",
              values: {
                position: index + 1,
                wrappedMessage: (0, _user_messages_utils.getLongMessage)(error)
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 1032,
                columnNumber: 15
              }
            })
          };
          return message;
        }
        return error;
      });
    });
  }
  return errorMessages;
}
function getInvalidDimensionErrorMessages(state, currentErrorMessages, isInvalidColumn) {
  // generate messages for invalid columns
  const columnErrorMessages = Object.keys(state.layers).map(layerId => {
    const messages = [];
    for (const columnId of Object.keys(state.layers[layerId].columns)) {
      if ((0, _get_application_user_messages.filterAndSortUserMessages)(currentErrorMessages, 'dimensionButton', {
        dimensionId: columnId
      }).length > 0) {
        // there is already a more specific user message assigned to this column, so no need
        // to add the default "is invalid" messaging
        continue;
      }
      if (isInvalidColumn(layerId, columnId)) {
        messages.push({
          uniqueId: _user_messages_ids.EDITOR_INVALID_DIMENSION,
          severity: 'error',
          displayLocations: [{
            id: 'dimensionButton',
            dimensionId: columnId
          }],
          fixableInEditor: true,
          shortMessage: '',
          longMessage: /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1082,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.lens.configure.invalidConfigTooltip', {
            defaultMessage: 'Invalid configuration.'
          }), /*#__PURE__*/_react.default.createElement("br", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 1086,
              columnNumber: 17
            }
          }), _i18n.i18n.translate('xpack.lens.configure.invalidConfigTooltipClick', {
            defaultMessage: 'Click for more details.'
          }))
        });
      }
    }
    return messages;
  }).flat();
  return columnErrorMessages;
}