"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldInput = FieldInput;
exports.getErrorMessage = getErrorMessage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _layer_helpers = require("../operations/layer_helpers");
var _field_select = require("./field_select");
var _pure_utils = require("../pure_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/field_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FieldInput({
  layer,
  selectedColumn,
  columnId,
  indexPattern,
  operationSupportMatrix,
  updateLayer,
  onDeleteColumn,
  incompleteField,
  incompleteOperation,
  incompleteParams,
  currentFieldIsInvalid,
  helpMessage,
  groupId,
  dimensionGroups,
  operationDefinitionMap
}) {
  const selectedOperationDefinition = selectedColumn && operationDefinitionMap[selectedColumn.operationType];
  // Need to workout early on the error to decide whether to show this or an help text
  const fieldErrorMessage = ((selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input) !== 'fullReference' && (selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input) !== 'managedReference' || incompleteOperation && operationDefinitionMap[incompleteOperation].input === 'field') && getErrorMessage(selectedColumn, Boolean(incompleteOperation), selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input, currentFieldIsInvalid);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "indexPattern-field-selection-row",
    label: _i18n.i18n.translate('xpack.lens.indexPattern.chooseField', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    isInvalid: Boolean(incompleteOperation || currentFieldIsInvalid),
    error: fieldErrorMessage,
    labelAppend: !fieldErrorMessage && helpMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    fieldIsInvalid: currentFieldIsInvalid,
    currentIndexPattern: indexPattern,
    operationByField: operationSupportMatrix.operationByField,
    selectedOperationType:
    // Allows operation to be selected before creating a valid column
    selectedColumn ? selectedColumn.operationType : incompleteOperation,
    selectedField: incompleteField !== null && incompleteField !== void 0 ? incompleteField : selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.sourceField,
    incompleteOperation: incompleteOperation,
    onDeleteColumn: onDeleteColumn,
    onChoose: choice => {
      return updateLayer((0, _layer_helpers.insertOrReplaceColumn)({
        layer,
        columnId,
        indexPattern,
        op: choice.operationType,
        field: indexPattern.getFieldByName(choice.field),
        visualizationGroups: dimensionGroups,
        targetGroup: groupId,
        incompleteParams
      }));
    },
    showTimeSeriesDimensions: (0, _pure_utils.shouldShowTimeSeriesOption)(layer, indexPattern, groupId, dimensionGroups),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }));
}
function getErrorMessage(selectedColumn, incompleteOperation, input, fieldInvalid) {
  if (selectedColumn && incompleteOperation) {
    if (input === 'field') {
      return _i18n.i18n.translate('xpack.lens.indexPattern.invalidOperationLabel', {
        defaultMessage: 'This field does not work with the selected function.'
      });
    }
    return _i18n.i18n.translate('xpack.lens.indexPattern.chooseFieldLabel', {
      defaultMessage: 'To use this function, select a field.'
    });
  }
  if (fieldInvalid) {
    return _i18n.i18n.translate('xpack.lens.indexPattern.invalidFieldLabel', {
      defaultMessage: 'Invalid field. Check your data view or pick another field.'
    });
  }
}