"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectComponentPluginServer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class InspectComponentPluginServer {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "isEnabled", void 0);
    const {
      enabled
    } = initializerContext.config.get();
    this.logger = initializerContext.logger.get();
    this.isDev = initializerContext.env.mode.dev;
    this.isEnabled = enabled;
  }
  setup(core) {
    if (this.isEnabled && this.isDev) {
      Promise.resolve().then(() => _interopRequireWildcard(require('./routes/routes'))).then(({
        registerInspectComponentRoutes
      }) => {
        registerInspectComponentRoutes({
          httpService: core.http,
          logger: this.logger
        });
      }).catch(() => {
        this.logger.error('Failed to import plugin files.');
      });
    }
    return {};
  }
  start(_core) {
    return {};
  }
  stop() {}
}
exports.InspectComponentPluginServer = InspectComponentPluginServer;