"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Fingerprint = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared_imports = require("../../../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/fingerprint.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fieldsConfig = {
  fields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.fingerprint.fieldNameField', {
      defaultMessage: 'Fields'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.fingerprint.fieldNameHelpText', {
      defaultMessage: 'Fields to include in the fingerprint.'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.fingerprint.fieldNameRequiredError', {
        defaultMessage: 'A field value is required.'
      }))
    }]
  },
  salt: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.fingerprint.saltFieldLabel', {
      defaultMessage: 'Salt (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.fingerprint.saltHelpText",
      defaultMessage: "Salt value for the hash function.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    })
  },
  method: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'SHA-1',
    serializer: v => v === 'SHA-1' || v === '' ? undefined : v,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.fingerprint.methodFieldLabel', {
      defaultMessage: 'Method'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.fingerprint.methodHelpText",
      defaultMessage: "Hash method used to compute the fingerprint.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    })
  }
};
const Fingerprint = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.fields,
    component: _shared_imports.ComboBoxField,
    path: "fields.fields",
    "data-test-subj": "fieldsValueField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.fingerprint.targetFieldHelpText",
      defaultMessage: "Output field. Defaults to {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 22
          }
        }, 'fingerprint')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'methodsValueField',
        options: [{
          value: 'MD5',
          text: 'MD5'
        }, {
          value: 'SHA-1',
          text: 'SHA-1'
        }, {
          value: 'SHA-256',
          text: 'SHA-256'
        }, {
          value: 'SHA-512',
          text: 'SHA-512'
        }, {
          value: 'MurmurHash3',
          text: 'MurmurHash3'
        }]
      }
    },
    config: fieldsConfig.method,
    component: _shared_imports.SelectField,
    path: "fields.method",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.salt,
    component: _shared_imports.Field,
    path: "fields.salt",
    "data-test-subj": "saltValueField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.fingerprint.ignoreMissingFieldHelpText",
      defaultMessage: "Ignore any missing {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 22
          }
        }, 'fields')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
};
exports.Fingerprint = Fingerprint;