"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _metrics_source = require("../../../../../containers/metrics_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/custom_field_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CustomFieldPanel = ({
  onSubmit,
  currentOptions
}) => {
  var _metricsView$fields;
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const [selectedOptions, setSelectedOptions] = _react.default.useState([]);
  const handleSubmit = () => {
    onSubmit(selectedOptions[0].label);
  };
  const handleFieldSelection = newSelection => {
    setSelectedOptions(newSelection);
  };
  const options = ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).filter(f => f.aggregatable && f.type === 'string' && !(currentOptions && currentOptions.some(o => o.field === f.name))).map(f => ({
    label: f.name
  }));
  const isSubmitDisabled = !selectedOptions.length;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: 16
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.waffle.customGroupByFieldLabel', {
      defaultMessage: 'Field'
    }),
    helpText: _i18n.i18n.translate('xpack.infra.waffle.customGroupByHelpText', {
      defaultMessage: 'This is the field used for the terms aggregation'
    }),
    display: "rowCompressed",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "groupByCustomField",
    placeholder: _i18n.i18n.translate('xpack.infra.waffle.customGroupByDropdownPlacehoder', {
      defaultMessage: 'Select one'
    }),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    options: options,
    onChange: handleFieldSelection,
    fullWidth: true,
    isClearable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "groupByCustomFieldAddButton",
    disabled: isSubmitDisabled,
    type: "submit",
    size: "s",
    fill: true,
    onClick: handleSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.infra..addButtonLabel', {
    defaultMessage: 'Add'
  }))));
};
exports.CustomFieldPanel = CustomFieldPanel;