"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCountSparkline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _single_metric_comparison = require("./single_metric_comparison");
var _single_metric_sparkline = require("./single_metric_sparkline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/log_entry_count_sparkline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryCountSparkline = ({
  currentCount,
  histograms,
  timeRange
}) => {
  const metric = (0, _react.useMemo)(() => {
    var _histograms$find$buck, _histograms$find, _histograms$find$buck2;
    return (_histograms$find$buck = (_histograms$find = histograms.find(histogram => histogram.histogramId === 'history')) === null || _histograms$find === void 0 ? void 0 : (_histograms$find$buck2 = _histograms$find.buckets) === null || _histograms$find$buck2 === void 0 ? void 0 : _histograms$find$buck2.map(({
      startTime: timestamp,
      logEntryCount: value
    }) => ({
      timestamp,
      value
    }))) !== null && _histograms$find$buck !== void 0 ? _histograms$find$buck : [];
  }, [histograms]);
  const referenceCount = (0, _react.useMemo)(() => {
    var _histograms$find$buck3, _histograms$find2, _histograms$find2$buc, _histograms$find2$buc2;
    return (_histograms$find$buck3 = (_histograms$find2 = histograms.find(histogram => histogram.histogramId === 'reference')) === null || _histograms$find2 === void 0 ? void 0 : (_histograms$find2$buc = _histograms$find2.buckets) === null || _histograms$find2$buc === void 0 ? void 0 : (_histograms$find2$buc2 = _histograms$find2$buc[0]) === null || _histograms$find2$buc2 === void 0 ? void 0 : _histograms$find2$buc2.logEntryCount) !== null && _histograms$find$buck3 !== void 0 ? _histograms$find$buck3 : 0;
  }, [histograms]);
  const overallTimeRange = (0, _react.useMemo)(() => ({
    endTime: timeRange.endTime,
    startTime: timeRange.startTime - (timeRange.endTime - timeRange.startTime)
  }), [timeRange.endTime, timeRange.startTime]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_single_metric_sparkline.SingleMetricSparkline, {
    metric: metric,
    timeRange: overallTimeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_single_metric_comparison.SingleMetricComparison, {
    previousValue: referenceCount,
    currentValue: currentCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.LogEntryCountSparkline = LogEntryCountSparkline;