"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessRow = exports.ContextualInsightProcessRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _process_row_charts = require("./process_row_charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/processes/process_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ContextualInsightProcessRow = ({
  command
}) => {
  const {
    observabilityAIAssistant
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const explainProcessMessages = (0, _react.useMemo)(() => {
    if (!command || !observabilityAIAssistant) {
      return undefined;
    }
    return observabilityAIAssistant.getContextualInsightMessages({
      message: `I am a software engineer. I am trying to understand what this process running on my
      machine does.`,
      instructions: `Your task is to first describe what the process is and what its general use cases are. If I also provide you
      with the arguments to the process you should then explain its arguments and how they influence the behaviour
      of the process. If I do not provide any arguments then explain the behaviour of the process when no arguments are
      provided.

      Here is an example with arguments.
      Process: metricbeat -c /etc/metricbeat.yml -d autodiscover,kafka -e -system.hostfs=/hostfs
      Explanation: Metricbeat is part of the Elastic Stack. It is a lightweight shipper that you can install on your
      servers to periodically collect metrics from the operating system and from services running on the server.
      Use cases for Metricbeat generally revolve around infrastructure monitoring. You would typically install
      Metricbeat on your servers to collect metrics from your systems and services. These metrics are then
      used for performance monitoring, anomaly detection, system status checks, etc.
      Here is a breakdown of the arguments used:
      * -c /etc/metricbeat.yml: The -c option is used to specify the configuration file for Metricbeat. In
      this case, /etc/metricbeat.yml is the configuration file. This file contains configurations for what
      metrics to collect and where to send them (e.g., to Elasticsearch or Logstash).
      * -d autodiscover,kafka: The -d option is used to enable debug output for selected components. In
      this case, debug output is enabled for autodiscover and kafka components. The autodiscover feature
      allows Metricbeat to automatically discover services as they get started and stopped in your environment,
      and kafka is presumably a monitored service from which Metricbeat collects metrics.
      * -e: The -e option is used to log to stderr and disable syslog/file output. This is useful for debugging.
      * -system.hostfs=/hostfs: The -system.hostfs option is used to set the mount point of the host’s
      filesystem for use in monitoring a host from within a container. In this case, /hostfs is the mount
      point. When running Metricbeat inside a container, filesystem metrics would be for the container by
      default, but with this option, Metricbeat can get metrics for the host system.
      Here is an example without arguments.
      Process: metricbeat
      Explanation: Metricbeat is part of the Elastic Stack. It is a lightweight shipper that you can install on your
      servers to periodically collect metrics from the operating system and from services running on the server.
      Use cases for Metricbeat generally revolve around infrastructure monitoring. You would typically install
      Metricbeat on your servers to collect metrics from your systems and services. These metrics are then
      used for performance monitoring, anomaly detection, system status checks, etc.
      Running it without any arguments will start the process with the default configuration file, typically
      located at /etc/metricbeat/metricbeat.yml. This file specifies the metrics to be collected and where
      to ship them to.
      Now explain this process to me.
      Process: ${command}
      Explanation:`
    });
  }, [command, observabilityAIAssistant]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, observabilityAIAssistant !== null && observabilityAIAssistant !== void 0 && observabilityAIAssistant.ObservabilityAIAssistantContextualInsight && explainProcessMessages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(observabilityAIAssistant.ObservabilityAIAssistantContextualInsight, {
    title: explainProcessMessageTitle,
    messages: explainProcessMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  })))) : null);
};
exports.ContextualInsightProcessRow = ContextualInsightProcessRow;
const ProcessRow = ({
  cells,
  item,
  supportAIAssistant = false,
  visibleColumnsCount
}) => {
  const [isExpanded, toggle] = (0, _useToggle.default)(false);
  const colSpan = visibleColumnsCount + 1;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    isExpander: true,
    textOnly: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.processRow.button.ariaLabel', {
      defaultMessage: 'Expand process details'
    }),
    "data-test-subj": "infraProcessRowButton",
    iconType: isExpanded ? 'arrowDown' : 'arrowRight',
    "aria-expanded": isExpanded,
    onClick: toggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  })), cells), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    isExpandable: true,
    isExpandedRow: isExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, isExpanded && /*#__PURE__*/_react.default.createElement(ExpandedRowCell, {
    colSpan: colSpan,
    textOnly: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(ExpandedRowDescriptionList, {
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCommand', {
    defaultMessage: 'Command'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(ExpandedCommandLine, {
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 23
    }
  }, item.command)))), item.apmTrace && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessRowViewTraceInApmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.viewTraceInAPM', {
    defaultMessage: 'View trace in APM'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelPID', {
    defaultMessage: 'PID'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(CodeListItem, {
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 21
    }
  }, item.pid))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.expandedRowLabelUser', {
    defaultMessage: 'User'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(CodeListItem, {
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 21
    }
  }, item.user))), /*#__PURE__*/_react.default.createElement(_process_row_charts.ProcessRowCharts, {
    command: item.command,
    hasCpuData: item.cpu !== null,
    hasMemoryData: item.memory !== null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  })), supportAIAssistant && /*#__PURE__*/_react.default.createElement(ContextualInsightProcessRow, {
    command: item.command,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 38
    }
  })))));
};
exports.ProcessRow = ProcessRow;
const explainProcessMessageTitle = _i18n.i18n.translate('xpack.infra.hostFlyout.explainProcessMessageTitle', {
  defaultMessage: "What's this process?"
});
const ExpandedRowDescriptionList = (0, _styled.default)(_eui.EuiDescriptionList)`
  width: 100%;
`;
const CodeListItem = (0, _styled.default)(_eui.EuiCode)`
  padding: 0 !important;
  & code.euiCodeBlock__code {
    white-space: nowrap !important;
    vertical-align: middle;
  }
`;
const ExpandedCommandLine = (0, _styled.default)(_eui.EuiCode)`
  padding: 0 !important;
  margin-bottom: ${props => props.theme.euiTheme.size.s};
`;
const ExpandedRowCell = (0, _styled.default)(_eui.EuiTableRowCell)`
  padding-top: ${props => props.theme.euiTheme.size.m} !important;
  padding-bottom: ${props => props.theme.euiTheme.size.m} !important;
  background-color: ${props => props.theme.euiTheme.colors.lightestShade};
`;