"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostCharts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _visualizations = require("../../../common/visualizations");
var _translations = require("../translations");
var _section = require("../components/section");
var _charts_grid = require("../charts_grid/charts_grid");
var _chart = require("./chart");
var _use_host_metrics_charts = require("../hooks/use_host_metrics_charts");
var _section_title = require("../components/section_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/charts/host_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FRAGMENT_BASE = 'key-metrics';
const HostCharts = exports.HostCharts = /*#__PURE__*/_react.default.forwardRef(({
  entityId,
  dataView,
  dateRange,
  metric,
  onShowAll,
  overview = false,
  schema
}, ref) => {
  const {
    charts
  } = (0, _use_host_metrics_charts.useHostCharts)({
    metric,
    indexPattern: dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern(),
    overview,
    schema
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: /*#__PURE__*/_react.default.createElement(_section_title.TitleWithTooltip, {
      title: _translations.HOST_METRIC_GROUP_TITLES[metric],
      tooltipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.charts.host.toolTip",
        defaultMessage: "See host-related {link} for more information",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "infraAssetDetailsViewHostMetricsDocumentationLink",
            href: `${_visualizations.HOST_METRICS_DOC_HREF}#${FRAGMENT_BASE}-${metric}`,
            target: "_blank",
            className: (0, _css.cx)({
              [(0, _css.css)`
                            text-transform: lowercase;
                          `]: metric !== 'cpu'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 51,
              columnNumber: 23
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.infra.assetDetails.charts.host.toolTip.linkText",
            defaultMessage: "{metric} metrics",
            values: {
              metric: _translations.HOST_METRIC_GROUP_TITLES[metric]
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 61,
              columnNumber: 25
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 17
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    }),
    "data-test-subj": `infraAssetDetailsHostChartsSection${metric}`,
    id: metric,
    ref: ref,
    extraAction: onShowAll ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": _i18n.i18n.translate('xpack.infra.assetDetails.charts.host.showAllButton.ariaLabel', {
        defaultMessage: 'Show all {metric} charts',
        values: {
          metric: _translations.HOST_METRIC_GROUP_TITLES[metric]
        }
      }),
      "data-test-subj": "infraAssetDetailsHostChartsShowAllButton",
      onClick: () => onShowAll(metric),
      size: "xs",
      flush: "both",
      iconSide: "right",
      iconType: "sortRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.charts.host.showAllButton",
      defaultMessage: "Show all",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    })) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts_grid.ChartsGrid, {
    columns: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, charts.map(chart => /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    id: chart.id,
    key: chart.id,
    entityId: entityId,
    dateRange: dateRange,
    dataView: dataView,
    lensAttributes: chart,
    queryField: (0, _common.findInventoryFields)('host').id,
    overrides: {
      settings: {
        legendAction: 'ignore'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }))));
});