"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePhaseTimings = exports.PhaseTimingsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/form/phase_timings_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getPhaseTimingConfiguration = formData => {
  var _formData$_meta, _formData$_meta$warm, _formData$_meta2, _formData$_meta2$cold, _formData$_meta3, _formData$_meta3$froz;
  const isWarmPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta = formData._meta) === null || _formData$_meta === void 0 ? void 0 : (_formData$_meta$warm = _formData$_meta.warm) === null || _formData$_meta$warm === void 0 ? void 0 : _formData$_meta$warm.enabled;
  const isColdPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta2 = formData._meta) === null || _formData$_meta2 === void 0 ? void 0 : (_formData$_meta2$cold = _formData$_meta2.cold) === null || _formData$_meta2$cold === void 0 ? void 0 : _formData$_meta2$cold.enabled;
  const isFrozenPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta3 = formData._meta) === null || _formData$_meta3 === void 0 ? void 0 : (_formData$_meta3$froz = _formData$_meta3.frozen) === null || _formData$_meta3$froz === void 0 ? void 0 : _formData$_meta3$froz.enabled;
  return {
    hot: {
      isFinalDataPhase: !isWarmPhaseEnabled && !isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    warm: {
      isFinalDataPhase: isWarmPhaseEnabled && !isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    cold: {
      isFinalDataPhase: isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    frozen: {
      isFinalDataPhase: isFrozenPhaseEnabled
    }
  };
};
const PhaseTimingsContext = /*#__PURE__*/(0, _react.createContext)(null);
const PhaseTimingsProvider = ({
  children
}) => {
  const {
    deleteEnabled
  } = (0, _.useGlobalFields)();
  const [formData] = (0, _shared_imports.useFormData)({
    watch: ['_meta.warm.enabled', '_meta.cold.enabled', '_meta.frozen.enabled', '_meta.delete.enabled']
  });
  return /*#__PURE__*/_react.default.createElement(PhaseTimingsContext.Provider, {
    value: {
      ...getPhaseTimingConfiguration(formData),
      isDeletePhaseEnabled: deleteEnabled.value,
      setDeletePhaseEnabled: deleteEnabled.setValue
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, children);
};
exports.PhaseTimingsProvider = PhaseTimingsProvider;
const usePhaseTimings = () => {
  const ctx = (0, _react.useContext)(PhaseTimingsContext);
  if (!ctx) throw new Error('Cannot use phase timings outside of phase timings context');
  return ctx;
};
exports.usePhaseTimings = usePhaseTimings;