"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormErrorsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _form = require("../form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/form_errors_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  callout: {
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyErrorCalloutTitle', {
      defaultMessage: 'This policy contains errors'
    }),
    body: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyErrorCalloutDescription', {
      defaultMessage: 'Please fix all errors before saving the policy.'
    })
  }
};
const FormErrorsCallout = () => {
  const {
    errors: {
      hasErrors
    },
    isFormSubmitted
  } = (0, _form.useFormErrorsContext)();
  if (!isFormSubmitted || !hasErrors) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "policyFormErrorsCallout",
    color: "danger",
    title: i18nTexts.callout.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, i18nTexts.callout.body), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.FormErrorsCallout = FormErrorsCallout;