"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAzureArmPropsFromPackagePolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AZURE_ACCOUNT_TYPE = 'azure.account_type';

/**
 * Get the Azure Arm Template url from a package policy
 * It looks for a config with an arm_template_url object present in the enabled inputs of the package policy
 */
const getAzureArmPropsFromPackagePolicy = packagePolicy => {
  var _packagePolicy$inputs, _packagePolicy$inputs2, _packagePolicy$inputs3, _packagePolicy$inputs4, _packagePolicy$inputs5, _packagePolicy$inputs6, _packagePolicy$inputs7, _packagePolicy$inputs8, _packagePolicy$inputs9, _packagePolicy$inputs10;
  const templateUrl = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : (_packagePolicy$inputs2 = _packagePolicy$inputs.find(input => input.enabled)) === null || _packagePolicy$inputs2 === void 0 ? void 0 : (_packagePolicy$inputs3 = _packagePolicy$inputs2.config) === null || _packagePolicy$inputs3 === void 0 ? void 0 : (_packagePolicy$inputs4 = _packagePolicy$inputs3.arm_template_url) === null || _packagePolicy$inputs4 === void 0 ? void 0 : _packagePolicy$inputs4.value;
  const azureAccountType = packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs5 = packagePolicy.inputs) === null || _packagePolicy$inputs5 === void 0 ? void 0 : (_packagePolicy$inputs6 = _packagePolicy$inputs5.find(input => input.enabled)) === null || _packagePolicy$inputs6 === void 0 ? void 0 : (_packagePolicy$inputs7 = _packagePolicy$inputs6.streams) === null || _packagePolicy$inputs7 === void 0 ? void 0 : (_packagePolicy$inputs8 = _packagePolicy$inputs7[0]) === null || _packagePolicy$inputs8 === void 0 ? void 0 : (_packagePolicy$inputs9 = _packagePolicy$inputs8.vars) === null || _packagePolicy$inputs9 === void 0 ? void 0 : (_packagePolicy$inputs10 = _packagePolicy$inputs9[AZURE_ACCOUNT_TYPE]) === null || _packagePolicy$inputs10 === void 0 ? void 0 : _packagePolicy$inputs10.value;
  return {
    templateUrl,
    azureAccountType
  };
};
exports.getAzureArmPropsFromPackagePolicy = getAzureArmPropsFromPackagePolicy;