"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallManagedAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _install_section = require("../../enrollment_instructions/install_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/install_managed_agent_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const InstallManagedAgentStep = ({
  installCommand,
  selectedApiKeyId,
  apiKeyData,
  isK8s,
  cloudSecurityIntegration,
  enrollToken,
  fleetServerHost,
  isComplete,
  fullCopyButton,
  onCopy,
  rootIntegrations,
  nonFipsIntegrations
}) => {
  const nonCompleteStatus = selectedApiKeyId ? undefined : 'disabled';
  const status = isComplete ? 'complete' : nonCompleteStatus;
  return {
    status,
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepEnrollAndRunAgentTitle', {
      defaultMessage: 'Install Elastic Agent on your host'
    }),
    children: selectedApiKeyId && apiKeyData ? /*#__PURE__*/_react.default.createElement(_install_section.InstallSection, {
      installCommand: installCommand,
      isK8s: isK8s,
      cloudSecurityIntegration: cloudSecurityIntegration,
      enrollToken: enrollToken,
      onCopy: onCopy,
      fullCopyButton: fullCopyButton,
      fleetServerHost: fleetServerHost,
      rootIntegrations: rootIntegrations,
      nonFipsIntegrations: nonFipsIntegrations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    })
  };
};
exports.InstallManagedAgentStep = InstallManagedAgentStep;