"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/update_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*

  Updating an integration to a new version entails a bit of logic. We allow the user to choose whether they'd like to
  simultaneously upgrade any package policies that include the current version of the integration. For example, if
  a user is running four agent policies that include the `nginx-0.2.4` package and they update to `nginx-0.7.0`, they
  can elect to also deploy the new integration version to any agent running one of those four agent policies.

  If the user does not elect to upgrade their running policies, we simply install the latest version of the package and
  navigate to the new version's settings page, e.g. `/detail/nginx-0.7.0/settings`.

  If the user _does_ elect to upgrade their running policies, we display a confirmation modal. In this modal, we'll report the
  number of agents and policies that will be affected by the upgrade, and if there are any conflicts. In the case of a conflict
  between versions, an upgrade for a given package policy will be skipped and the user will need to manually recreate their policy
  to resolve any breaking changes between versions. Once the user confirms, we first install the latest version of the integration,
  then we make a call to the "upgrade policies" API endpoint with a list of all package policy ID's that include the current version
  of the integration. This API endpoint will complete the upgrade process in bulk for each package policy provided. Upon completion,
  we navigate to the new version's settings page, as above.

*/

const UpdateButton = ({
  dryRunData,
  isUpgradingPackagePolicies = false,
  name,
  packagePolicyIds = [],
  agentPolicyIds = [],
  setIsUpgradingPackagePolicies = () => {},
  title,
  version,
  startServices,
  isDisabled = false
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    getPath
  } = (0, _hooks.useLink)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const canUpgradePackages = (0, _hooks.useAuthz)().integrations.upgradePackages;
  const installPackage = (0, _hooks.useInstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const isInstalling = installationStatus === _types.InstallStatus.installing;
  const [isUpdateModalVisible, setIsUpdateModalVisible] = (0, _react.useState)(false);
  const [upgradePackagePolicies, setUpgradePackagePolicies] = (0, _react.useState)(true);
  const {
    data: agentPolicyData
  } = (0, _hooks.useBulkGetAgentPoliciesQuery)(agentPolicyIds, {
    full: true
  });
  const packagePolicyCount = (0, _react.useMemo)(() => packagePolicyIds.length, [packagePolicyIds]);
  function isStringArray(arr) {
    return Array.isArray(arr) && arr.every(p => typeof p === 'string');
  }
  const agentCount = (0, _react.useMemo)(() => {
    if (!(agentPolicyData !== null && agentPolicyData !== void 0 && agentPolicyData.items)) return 0;
    return agentPolicyData.items.reduce((acc, item) => {
      const existingPolicies = item !== null && item !== void 0 && item.package_policies ? isStringArray(item.package_policies) ? item.package_policies.filter(p => packagePolicyIds.includes(p)) : item.package_policies.filter(p => packagePolicyIds.includes(p.id)) : [];
      return acc += existingPolicies.length > 0 && item !== null && item !== void 0 && item.agents ? item === null || item === void 0 ? void 0 : item.agents : 0;
    }, 0);
  }, [agentPolicyData, packagePolicyIds]);
  const conflictCount = (0, _react.useMemo)(() => dryRunData === null || dryRunData === void 0 ? void 0 : dryRunData.filter(item => item.hasErrors).length, [dryRunData]);
  const handleUpgradePackagePoliciesChange = (0, _react.useCallback)(() => {
    setUpgradePackagePolicies(prev => !prev);
  }, []);
  const navigateToNewSettingsPage = (0, _react.useCallback)(() => {
    // only navigate if still on old settings page (user has not navigated away)
    if (!history.location.pathname.match(getPath('integration_details_settings', {
      pkgkey: `${name}-.*`
    }))) {
      return;
    }
    const settingsPath = getPath('integration_details_settings', {
      pkgkey: `${name}-${version}`
    });
    history.push(settingsPath);
  }, [history, getPath, name, version]);
  const handleClickUpdate = (0, _react.useCallback)(async () => {
    await installPackage({
      name,
      version,
      title,
      isUpgrade: true
    });
    navigateToNewSettingsPage();
  }, [installPackage, name, title, version, navigateToNewSettingsPage]);
  const upgradePackagePoliciesMutation = (0, _hooks.useUpgradePackagePoliciesMutation)();
  const handleClickUpgradePolicies = (0, _react.useCallback)(async () => {
    if (isUpgradingPackagePolicies) {
      return;
    }
    setIsUpdateModalVisible(false);
    setIsUpgradingPackagePolicies(true);
    const hasUpgraded = await installPackage({
      name,
      version,
      title,
      isUpgrade: true
    });
    //  If install package failed do not upgrade package policies
    if (!hasUpgraded) {
      setIsUpgradingPackagePolicies(false);
      return;
    }

    // Only upgrade policies that don't have conflicts
    const packagePolicyIdsToUpdate = packagePolicyIds.filter(id => {
      var _dryRunData$find;
      return !(dryRunData !== null && dryRunData !== void 0 && (_dryRunData$find = dryRunData.find(dryRunRecord => {
        var _dryRunRecord$diff;
        return ((_dryRunRecord$diff = dryRunRecord.diff) === null || _dryRunRecord$diff === void 0 ? void 0 : _dryRunRecord$diff[0].id) === id;
      })) !== null && _dryRunData$find !== void 0 && _dryRunData$find.hasErrors);
    });
    if (!packagePolicyIdsToUpdate.length) {
      setIsUpgradingPackagePolicies(false);
      navigateToNewSettingsPage();
    }
    try {
      await upgradePackagePoliciesMutation.mutateAsync({
        packagePolicyIds: packagePolicyIdsToUpdate
      });
      notifications.toasts.addSuccess({
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUpdateSuccessTitle",
          defaultMessage: "Updated {title} and upgraded policies",
          values: {
            title
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 187,
            columnNumber: 11
          }
        }), startServices),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.integrations.packageUpdateSuccessDescription",
          defaultMessage: "Successfully updated {title} and upgraded policies",
          values: {
            title
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 195,
            columnNumber: 11
          }
        }), startServices)
      });
      navigateToNewSettingsPage();
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.integrations.settings.errorUpdatingPoliciesToast.title', {
          defaultMessage: 'Error updating policies'
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.integrations.settings.errorUpdatingPoliciesToast.message', {
          defaultMessage: 'Integrations policies, need to be manually updated. \n Error: {error}',
          values: {
            error: error.message
          }
        })
      });
      setIsUpgradingPackagePolicies(false);
      navigateToNewSettingsPage();
    }
  }, [isUpgradingPackagePolicies, setIsUpgradingPackagePolicies, installPackage, name, version, title, upgradePackagePoliciesMutation, packagePolicyIds, dryRunData, notifications.toasts, startServices, navigateToNewSettingsPage]);
  const updateModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    isLoading: isUpgradingPackagePolicies,
    maxWidth: 568,
    onCancel: () => {
      setIsUpdateModalVisible(false);
    },
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.integrations.settings.confirmUpdateModal.cancel', {
      defaultMessage: 'Cancel'
    }),
    onConfirm: handleClickUpgradePolicies,
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.integrations.settings.confirmUpdateModal.confirm', {
      defaultMessage: 'Upgrade {packageName} and policies',
      values: {
        packageName: title
      }
    }),
    title: _i18n.i18n.translate('xpack.fleet.integrations.settings.confirmUpdateModal.updateTitle', {
      defaultMessage: 'Upgrade {packageName} and policies',
      values: {
        packageName: title
      }
    }),
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, conflictCount && conflictCount > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.fleet.integrations.settings.confirmUpdateModal.conflictCallOut.title', {
      defaultMessage: 'Some integration policies have conflicts'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.confirmUpdateModal.conflictCallOut.integrationPolicyCount",
    defaultMessage: "{conflictCount, plural, one { # integration policy} other { # integration policies}}",
    values: {
      conflictCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  })), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.confirmUpdateModal.conflictCallOut.body",
    defaultMessage: "{conflictCount, plural, one { has} other { have}} conflicts and will not be upgraded automatically. You can manually resolve these conflicts via agent policy settings in Fleet after performing this upgrade.",
    values: {
      conflictCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.confirmUpdateModal.body",
    defaultMessage: "This action will deploy updates to all agents which use these policies. Fleet has detected that {packagePolicyCountText} {packagePolicyCount, plural, one { is} other { are}} ready to be upgraded and {packagePolicyCount, plural, one { is} other { are}} already in use by {agentCountText}.",
    values: {
      packagePolicyCount,
      packagePolicyCountText: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrations.confirmUpdateModal.body.policyCount",
        defaultMessage: "{packagePolicyCount, plural, one {# integration policy} other {# integration policies}}",
        values: {
          packagePolicyCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 17
        }
      })),
      agentCountText: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 310,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.integrations.confirmUpdateModal.body.agentCount",
        defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
        values: {
          agentCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isInstalling || isUpgradingPackagePolicies,
    onClick: upgradePackagePolicies ? () => setIsUpdateModalVisible(true) : handleClickUpdate,
    "data-test-subj": "updatePackageBtn",
    isDisabled: isDisabled || !canUpgradePackages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.updatePackage.updatePackageButtonLabel",
    defaultMessage: "Upgrade to latest version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 13
    }
  }))), packagePolicyCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    labelProps: {
      style: {
        display: 'flex'
      }
    },
    id: "upgradePoliciesCheckbox",
    "data-test-subj": "epmDetails.upgradePoliciesCheckbox",
    disabled: !canUpgradePackages,
    checked: upgradePackagePolicies,
    onChange: handleUpgradePackagePoliciesChange,
    label: _i18n.i18n.translate('xpack.fleet.integrations.updatePackage.upgradePoliciesCheckboxLabel', {
      defaultMessage: 'Upgrade integration policies'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 13
    }
  }))), isUpdateModalVisible && updateModal);
};
exports.UpdateButton = UpdateButton;