"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaHeaders = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_kafka_headers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OutputFormKafkaHeaders = props => {
  const {
    inputs
  } = props;
  const {
    props: {
      onChange
    },
    value: keyValuePairs,
    formRowProps: {
      error: errors
    }
  } = inputs.kafkaHeadersInput;
  const [autoFocus, setAutoFocus] = (0, _react.useState)(false);
  const handleKeyValuePairChange = (0, _react.useCallback)((index, field, value) => {
    const updatedPairs = keyValuePairs.map((pair, i) => {
      if (i === index) {
        return {
          ...pair,
          [field]: value
        };
      }
      return pair;
    });
    onChange(updatedPairs);
  }, [keyValuePairs, onChange]);
  const addKeyValuePair = (0, _react.useCallback)(() => {
    setAutoFocus(true);
    const updatedPairs = [...keyValuePairs, {
      key: '',
      value: ''
    }];
    onChange(updatedPairs);
  }, [keyValuePairs, onChange]);
  const deleteKeyValuePair = (0, _react.useCallback)(index => {
    const updatedPairs = keyValuePairs.filter((_, i) => i !== index);
    onChange(updatedPairs);
  }, [keyValuePairs, onChange]);
  const deleteButtonDisabled = keyValuePairs.length === 1;
  const addKeyValuePairButtonDisabled = keyValuePairs.length === 1 && (keyValuePairs[0].key === '' || keyValuePairs[0].value === '');
  const displayErrors = errorMessages => {
    return errorMessages !== null && errorMessages !== void 0 && errorMessages.length ? errorMessages.map((item, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
      key: idx,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 42
      }
    }, item)) : null;
  };
  const matchErrorsByIndex = (0, _react.useMemo)(() => (index, errorType) => {
    const headersErrors = errors;
    return headersErrors === null || headersErrors === void 0 ? void 0 : headersErrors.filter(error => error.index === index && (errorType === 'key' ? error.hasKeyError : error.hasValueError)).map(error => error.message);
  }, [errors]);
  const globalErrors = (0, _react.useMemo)(() => {
    return errors && errors.filter(err => err.index === undefined).map(({
      message
    }) => message);
  }, [errors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaHeadersPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaHeaders",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaHeadersTitle",
    defaultMessage: "Headers",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), keyValuePairs.map((pair, index) => {
    var _keyErrors$length, _keyErrors$length2, _valueErrors$length, _valueErrors$length2;
    const keyErrors = matchErrorsByIndex(index, 'key');
    const valueErrors = matchErrorsByIndex(index, 'value');
    return /*#__PURE__*/_react.default.createElement("div", {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 27
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "none",
      style: {
        gap: 30
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.kafkaHeaderKeyInputLabel",
        defaultMessage: "Key",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 21
        }
      }),
      error: displayErrors(keyErrors),
      isInvalid: ((_keyErrors$length = keyErrors === null || keyErrors === void 0 ? void 0 : keyErrors.length) !== null && _keyErrors$length !== void 0 ? _keyErrors$length : 0) > 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: ((_keyErrors$length2 = keyErrors === null || keyErrors === void 0 ? void 0 : keyErrors.length) !== null && _keyErrors$length2 !== void 0 ? _keyErrors$length2 : 0) > 0,
      "data-test-subj": `settingsOutputsFlyout.kafkaHeadersKeyInput${index}`,
      fullWidth: true,
      value: pair.key,
      onChange: e => handleKeyValuePairChange(index, 'key', e.target.value),
      autoFocus: autoFocus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.kafkaHeaderValueInputLabel",
        defaultMessage: "Value",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 21
        }
      }),
      error: displayErrors(valueErrors),
      isInvalid: ((_valueErrors$length = valueErrors === null || valueErrors === void 0 ? void 0 : valueErrors.length) !== null && _valueErrors$length !== void 0 ? _valueErrors$length : 0) > 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: ((_valueErrors$length2 = valueErrors === null || valueErrors === void 0 ? void 0 : valueErrors.length) !== null && _valueErrors$length2 !== void 0 ? _valueErrors$length2 : 0) > 0,
      "data-test-subj": `settingsOutputsFlyout.kafkaHeadersValueInput${index}`,
      fullWidth: true,
      value: pair.value,
      onChange: e => handleKeyValuePairChange(index, 'value', e.target.value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        marginTop: 28
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `settingsOutputsFlyout.kafkaHeadersDeleteButton${index}`,
      color: "text",
      onClick: () => deleteKeyValuePair(index),
      iconType: "cross",
      disabled: deleteButtonDisabled,
      "aria-label": _i18n.i18n.translate('xpack.fleet.kafkaHeadersInput.deleteButton', {
        defaultMessage: 'Delete row'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 17
      }
    }))));
  }), displayErrors(globalErrors), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "kafkaHeaders.multiRowInput.addRowButton",
    disabled: addKeyValuePairButtonDisabled,
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    onClick: addKeyValuePair,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.kafkaHeadersInput.addRow",
    defaultMessage: "Add header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaClientIdLabel",
      defaultMessage: "Client ID",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    })
  }, inputs.kafkaClientIdInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "settingsOutputsFlyout.kafkaClientIdInput",
    fullWidth: true
  }, inputs.kafkaClientIdInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }))));
};
exports.OutputFormKafkaHeaders = OutputFormKafkaHeaders;