"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentHealth = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _agent_status = require("../../../../../../common/services/agent_status");
var _hooks = require("../../../hooks");
var _hooks2 = require("../agent_details_page/hooks");
var _agent_upgrade_modal = require("./agent_upgrade_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/components/agent_health.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getStatusComponent({
  status,
  upgradeDetails,
  ...restOfProps
}) {
  switch (status) {
    case 'error':
    case 'degraded':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.unhealthyStatusText",
        defaultMessage: "Unhealthy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }));
    case 'inactive':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDarkShade
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.inactiveStatusText",
        defaultMessage: "Inactive",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 11
        }
      }));
    case 'offline':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.offlineStatusText",
        defaultMessage: "Offline",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }));
    case 'uninstalled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.uninstalledStatusText",
        defaultMessage: "Uninstalled",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }));
    case 'orphaned':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.orphanedStatusText",
        defaultMessage: "Orphaned",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }));
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return (0, _agent_status.isAgentInFailedUpgradeState)(upgradeDetails) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "danger"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradingFailedStatusText",
        defaultMessage: "Upgrade failed",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "primary"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.updatingStatusText",
        defaultMessage: "Updating",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      }));
    case 'unenrolled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDisabled
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.unenrolledStatusText",
        defaultMessage: "Unenrolled",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "success"
      }, restOfProps, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.healthyStatusText",
        defaultMessage: "Healthy",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      }));
  }
}
const WrappedEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  white-space: wrap !important;
`;
const AgentHealth = ({
  agent,
  fromDetails,
  ...restOfProps
}) => {
  const {
    last_checkin: lastCheckIn,
    last_checkin_message: lastCheckInMessage
  } = agent;
  const msLastCheckIn = new Date(lastCheckIn || 0).getTime();
  const lastCheckInMessageText = lastCheckInMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkinMessageText",
    defaultMessage: "Last checkin message: {lastCheckinMessage}",
    values: {
      lastCheckinMessage: lastCheckInMessage
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }) : null;
  const lastCheckinText = msLastCheckIn ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkInTooltipText",
    defaultMessage: "Last checked in {lastCheckIn}",
    values: {
      lastCheckIn: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastCheckIn,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 24
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.noCheckInTooltipText",
    defaultMessage: "Never checked in",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  });
  const previousToOfflineStatus = (0, _react.useMemo)(() => {
    if (!fromDetails || agent.status !== 'offline') {
      return;
    }
    return (0, _agent_status.getPreviousAgentStatusForOfflineAgents)(agent);
  }, [fromDetails, agent]);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const refreshAgent = (0, _hooks2.useAgentRefresh)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, lastCheckinText), /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 13
      }
    }, lastCheckInMessageText), (0, _agent_status.isStuckInUpdating)(agent) ? (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTooltipText",
      defaultMessage: "Agent upgrade failed. Consider restarting the upgrade.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.restartUpgradeTooltipText",
      defaultMessage: "Agent may be stuck updating. Consider restarting the upgrade.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 19
      }
    })) : null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, (0, _agent_status.isStuckInUpdating)(agent) && !fromDetails ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, getStatusComponent({
    status: agent.status,
    upgradeDetails: agent.upgrade_details,
    ...restOfProps
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getStatusComponent({
    status: agent.status,
    upgradeDetails: agent.upgrade_details,
    ...restOfProps
  }), previousToOfflineStatus ? getStatusComponent({
    status: previousToOfflineStatus,
    ...restOfProps
  }) : null)), fromDetails && (0, _agent_status.isStuckInUpdating)(agent) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(WrappedEuiCallOut, {
    iconType: "warning",
    size: "m",
    color: "warning",
    title: (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTitle",
      defaultMessage: "Agent upgrade is stuck in failed state.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.stuckUpdatingTitle",
      defaultMessage: "Agent may be stuck updating.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.stuckUpdatingText",
    defaultMessage: "{stuckMessage} Consider restarting the upgrade. {learnMore}",
    values: {
      stuckMessage: (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? 'Agent upgrade failed.' : 'Agent has been updating for a while, and may be stuck.',
      learnMore: /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 25
        }
      })))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    onClick: () => {
      setIsUpgradeModalOpen(true);
    },
    "data-test-subj": "restartUpgradeBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.restartUpgradeBtn",
    defaultMessage: "Restart upgrade",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 15
    }
  })))) : null, isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_upgrade_modal.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    },
    isUpdating: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  })));
};
exports.AgentHealth = AgentHealth;