"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyYamlFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _jsYaml = require("js-yaml");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _services = require("../../../services");
var _constants2 = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_yaml_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
const AgentPolicyYamlFlyout = exports.AgentPolicyYamlFlyout = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  onClose
}) => {
  var _agentPolicyData$item, _agentPolicyData$item2;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const core = (0, _hooks.useStartServices)();
  const {
    isLoading: isLoadingYaml,
    data: yamlData,
    error
  } = (0, _hooks.useGetOneAgentPolicyFull)(policyId);
  const {
    data: agentPolicyData
  } = (0, _hooks.useGetOneAgentPolicy)(policyId);
  const packagePoliciesContainSecrets = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : (_agentPolicyData$item = agentPolicyData.item) === null || _agentPolicyData$item === void 0 ? void 0 : (_agentPolicyData$item2 = _agentPolicyData$item.package_policies) === null || _agentPolicyData$item2 === void 0 ? void 0 : _agentPolicyData$item2.some(packagePolicy => {
    var _packagePolicy$secret;
    return packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$secret = packagePolicy.secret_references) === null || _packagePolicy$secret === void 0 ? void 0 : _packagePolicy$secret.length;
  });
  const body = isLoadingYaml ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }) : error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetails.ErrorGettingFullAgentPolicy",
      defaultMessage: "Error loading agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, error.message) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    isCopyable: true,
    fontSize: "m",
    whiteSpace: "pre",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, (0, _services.fullAgentPolicyToYaml)(yamlData.item, _jsYaml.dump)));
  const downloadLink = core.http.basePath.prepend(_services.agentPolicyRouteService.getInfoFullDownloadPath(policyId)) + `?apiVersion=${_constants2.API_VERSIONS.public.v1}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, agentPolicyData !== null && agentPolicyData !== void 0 && agentPolicyData.item ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlflyoutTitleWithName",
    defaultMessage: "''{name}'' agent policy",
    values: {
      name: agentPolicyData.item.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlflyoutTitleWithoutName",
    defaultMessage: "Agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }))), packagePoliciesContainSecrets && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.policyDetails.secretsTitle",
      defaultMessage: "This policy contains secret values",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 19
      }
    }),
    size: "m",
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.secretsDescription",
    defaultMessage: "Kibana does not have access to secret values. You will need to set these values manually after deploying the agent policy. Look out for environment variables in the format {envVarPrefix} in the agent configuration.",
    values: {
      envVarPrefix: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 35
        }
      }, '${SECRET_0}')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, body), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlFlyoutCloseButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: downloadLink,
    iconType: "download",
    isDisabled: Boolean(isLoadingYaml && !yamlData),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.yamlDownloadButtonLabel",
    defaultMessage: "Download policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }))))));
});