"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsFieldGroup = void 0;
var _zod = require("@kbn/zod");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _agent_policy_form = require("../../sections/agent_policy/components/agent_policy_form");
var _settings_field_wrapper = require("./settings_field_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/form_settings/settings_field_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SettingsFieldGroup = ({
  settingsConfig,
  disabled
}) => {
  const [errors, setErrors] = (0, _react.useState)({});
  const agentPolicyFormContext = (0, _agent_policy_form.useAgentPolicyFormContext)();
  const shape = settingsConfig.schema._def.innerType._def.shape();
  return /*#__PURE__*/_react.default.createElement(_settings_field_wrapper.SettingsFieldWrapper, {
    settingsConfig: settingsConfig,
    typeName: _zod.ZodFirstPartyTypeKind.ZodString,
    renderItem: ({}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, Object.keys(shape).map(key => {
      var _agentPolicyFormConte, _agentPolicyFormConte2, _agentPolicyFormConte3, _field$_def$descripti;
      const field = shape[key];
      const fieldKey = `configuredSetting-${settingsConfig.name}-${key}`;
      const defaultValue = field instanceof _zod.z.ZodDefault ? field._def.defaultValue() : undefined;
      const coercedSchema = field;
      const fieldValue = (_agentPolicyFormConte = agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : (_agentPolicyFormConte2 = agentPolicyFormContext.agentPolicy.advanced_settings) === null || _agentPolicyFormConte2 === void 0 ? void 0 : (_agentPolicyFormConte3 = _agentPolicyFormConte2[settingsConfig.api_field.name]) === null || _agentPolicyFormConte3 === void 0 ? void 0 : _agentPolicyFormConte3[key]) !== null && _agentPolicyFormConte !== void 0 ? _agentPolicyFormConte : defaultValue;
      const type = (0, _settings_field_wrapper.getInnerType)(field);
      const description = (_field$_def$descripti = field._def.description) !== null && _field$_def$descripti !== void 0 ? _field$_def$descripti : key;
      const handleChange = e => {
        const newValue = (0, _settings_field_wrapper.convertValue)(e.target.value, type);
        updateFieldValue(newValue);
      };
      const updateFieldValue = newValue => {
        var _agentPolicyFormConte4, _agentPolicyFormConte5;
        const validationError = (0, _settings_field_wrapper.validateSchema)(coercedSchema, newValue);
        if (validationError) {
          setErrors({
            ...errors,
            [key]: validationError
          });
          agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAdvancedSettingsHasErrors(true);
        } else {
          setErrors({
            ...errors,
            [key]: ''
          });
          agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAdvancedSettingsHasErrors(false);
        }
        const newApiFieldValue = {
          ...(agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : (_agentPolicyFormConte4 = agentPolicyFormContext.agentPolicy.advanced_settings) === null || _agentPolicyFormConte4 === void 0 ? void 0 : _agentPolicyFormConte4[settingsConfig.api_field.name]),
          [key]: newValue
        };
        const newAdvancedSettings = {
          ...((_agentPolicyFormConte5 = agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.agentPolicy.advanced_settings) !== null && _agentPolicyFormConte5 !== void 0 ? _agentPolicyFormConte5 : {}),
          [settingsConfig.api_field.name]: newApiFieldValue
        };
        agentPolicyFormContext === null || agentPolicyFormContext === void 0 ? void 0 : agentPolicyFormContext.updateAgentPolicy({
          advanced_settings: newAdvancedSettings
        });
      };
      const getFormField = () => {
        var _minValue, _maxValue;
        switch (type) {
          case _zod.ZodFirstPartyTypeKind.ZodNumber:
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
              fullWidth: true,
              disabled: disabled,
              "data-test-subj": fieldKey,
              value: fieldValue,
              onChange: handleChange,
              isInvalid: !!errors[key],
              min: (_minValue = field.minValue) !== null && _minValue !== void 0 ? _minValue : undefined,
              max: (_maxValue = field.maxValue) !== null && _maxValue !== void 0 ? _maxValue : undefined,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 92,
                columnNumber: 21
              }
            });
          case _zod.ZodFirstPartyTypeKind.ZodString:
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
              fullWidth: true,
              disabled: disabled,
              "data-test-subj": fieldKey,
              value: fieldValue,
              onChange: handleChange,
              isInvalid: !!errors[key],
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 105,
                columnNumber: 21
              }
            });
          case _zod.ZodFirstPartyTypeKind.ZodBoolean:
            return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
              label: '',
              disabled: disabled,
              checked: fieldValue,
              onChange: e => {
                updateFieldValue(e.target.checked);
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 116,
                columnNumber: 21
              }
            });
          default:
            return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
        }
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: `flexItem-${fieldKey}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        isDisabled: disabled,
        key: fieldKey,
        label: description,
        error: errors[key],
        isInvalid: !!errors[key],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 17
        }
      }, getFormField()));
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  });
};
exports.SettingsFieldGroup = SettingsFieldGroup;