"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NULL_LABEL = exports.NAN_LABEL = exports.MISSING_TOKEN = exports.EMPTY_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EMPTY_LABEL = exports.EMPTY_LABEL = _i18n.i18n.translate('fieldFormats.blankLabel', {
  defaultMessage: '(blank)',
  description: 'Represents the label used to replace an empty string value in tables and charts'
});
const NULL_LABEL = exports.NULL_LABEL = _i18n.i18n.translate('fieldFormats.nullLabel', {
  defaultMessage: '(null)',
  description: 'Represents the label used to replace an null value in tables and charts'
});
const NAN_LABEL = exports.NAN_LABEL = 'NaN';
const MISSING_TOKEN = exports.MISSING_TOKEN = '__missing__';