"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLineLayer = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _reference_line_annotations = require("./reference_line_annotations");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/reference_lines/reference_line_layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ReferenceLineLayer = ({
  layer,
  axesConfiguration,
  formatters,
  xAxisFormatter,
  paddingMap,
  isHorizontal,
  titles,
  yAxesMap
}) => {
  if (!layer.decorations) {
    return null;
  }
  const {
    columnToLabel,
    decorations,
    table
  } = layer;
  const columnToLabelMap = columnToLabel ? JSON.parse(columnToLabel) : {};
  const row = table.rows[0];
  const decorationConfigsByValue = decorations.sort(({
    forAccessor: idA
  }, {
    forAccessor: idB
  }) => row[idA] - row[idB]);
  const groupedByDirection = (0, _lodash.groupBy)(decorationConfigsByValue, 'fill');
  if (groupedByDirection.below) {
    groupedByDirection.below.reverse();
  }
  const referenceLineElements = decorationConfigsByValue.flatMap(decorationConfig => {
    var _columnToLabelMap$dec, _titles$yTitles;
    const axisGroup = (0, _utils.getAxisGroupForReferenceLine)(axesConfiguration, decorationConfig, isHorizontal);
    const formatter = formatters[decorationConfig.forAccessor] || (axisGroup === null || axisGroup === void 0 ? void 0 : axisGroup.formatter) || xAxisFormatter;
    const name = (_columnToLabelMap$dec = columnToLabelMap[decorationConfig.forAccessor]) !== null && _columnToLabelMap$dec !== void 0 ? _columnToLabelMap$dec : titles === null || titles === void 0 ? void 0 : (_titles$yTitles = titles.yTitles) === null || _titles$yTitles === void 0 ? void 0 : _titles$yTitles[decorationConfig.forAccessor];
    const value = row[decorationConfig.forAccessor];
    const yDecorationsWithSameDirection = groupedByDirection[decorationConfig.fill].filter(yDecoration => (0, _utils.getAxisGroupForReferenceLine)(axesConfiguration, yDecoration, isHorizontal) === axisGroup);
    const indexFromSameType = yDecorationsWithSameDirection.findIndex(({
      forAccessor
    }) => forAccessor === decorationConfig.forAccessor);
    const shouldCheckNextReferenceLine = indexFromSameType < yDecorationsWithSameDirection.length - 1;
    const nextValue = shouldCheckNextReferenceLine ? row[yDecorationsWithSameDirection[indexFromSameType + 1].forAccessor] : undefined;
    const {
      forAccessor,
      type,
      ...restAnnotationConfig
    } = decorationConfig;
    const id = `${layer.layerId}-${decorationConfig.forAccessor}`;
    return /*#__PURE__*/_react.default.createElement(_reference_line_annotations.ReferenceLineAnnotations, {
      key: id,
      config: {
        id,
        value,
        nextValue,
        name,
        ...restAnnotationConfig,
        axisGroup
      },
      axesMap: yAxesMap,
      paddingMap: paddingMap,
      formatter: formatter,
      isHorizontal: isHorizontal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    });
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, referenceLineElements);
};
exports.ReferenceLineLayer = ReferenceLineLayer;