"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportMetricOptions = ReportMetricOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_series_storage = require("../hooks/use_series_storage");
var _use_app_data_view = require("../hooks/use_app_data_view");
var _constants = require("../configurations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/report_metric_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ReportMetricOptions({
  seriesId,
  series,
  seriesConfig
}) {
  var _seriesConfig$metricO, _seriesConfig$metricO2, _seriesConfig$metricO3;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [showOptions, setShowOptions] = (0, _react.useState)(false);
  const metricOptions = seriesConfig === null || seriesConfig === void 0 ? void 0 : seriesConfig.metricOptions;
  const {
    dataViews,
    dataViewErrors,
    loading
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const onChange = value => {
    setSeries(seriesId, {
      ...series,
      selectedMetricField: value
    });
  };
  const focusButton = (0, _react.useCallback)(ref => {
    ref === null || ref === void 0 ? void 0 : ref.focus();
  }, []);
  if (!series.dataType) {
    return null;
  }
  const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[series.dataType];
  const dataViewError = dataViewErrors === null || dataViewErrors === void 0 ? void 0 : dataViewErrors[series.dataType];
  const options = (metricOptions !== null && metricOptions !== void 0 ? metricOptions : []).map(({
    label,
    field,
    id
  }) => {
    let disabled = false;
    if (field !== _constants.RECORDS_FIELD && field !== _constants.RECORDS_PERCENTAGE_FIELD && field) {
      disabled = !Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(field));
    }
    return {
      disabled,
      value: field || id,
      dropdownDisplay: disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.exploratoryView.expView.seriesEditor.selectReportMetric.noFieldData",
          defaultMessage: "No data available for field {field}.",
          values: {
            field: /*#__PURE__*/_react.default.createElement("strong", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 74,
                columnNumber: 24
              }
            }, field)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }, label)) : label,
      inputDisplay: label
    };
  });
  if (dataViewError && !dataView && !loading) {
    var _dataViewError$body, _dataViewError$body2;
    // TODO: Add a link to docs to explain how to add index patterns
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      className: "eui-textNoWrap",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, ((_dataViewError$body = dataViewError.body) === null || _dataViewError$body === void 0 ? void 0 : _dataViewError$body.error) === 'Forbidden' || dataViewError.name === 'DataViewInsufficientAccessError' ? NO_PERMISSIONS : (_dataViewError$body2 = dataViewError.body) === null || _dataViewError$body2 === void 0 ? void 0 : _dataViewError$body2.message);
  }
  if (!dataView && !loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 12
      }
    }, NO_DATA_AVAILABLE);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !series.selectedMetricField && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yReportMetricOptionsButton",
      iconType: "plusInCircle",
      onClick: () => setShowOptions(prevState => !prevState),
      fill: true,
      size: "s",
      isLoading: !dataView && loading,
      buttonRef: focusButton,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, SELECT_REPORT_METRIC_LABEL),
    isOpen: showOptions,
    closePopover: () => setShowOptions(prevState => !prevState),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, options.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: option.value,
    onClick: () => onChange(option.value),
    label: option.dropdownDisplay,
    isDisabled: option.disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  })))), series.selectedMetricField && (dataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: REPORT_METRIC_TOOLTIP,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "cross",
    iconSide: "right",
    iconOnClick: () => onChange(undefined),
    iconOnClickAriaLabel: REMOVE_REPORT_METRIC_LABEL,
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, (_seriesConfig$metricO = seriesConfig === null || seriesConfig === void 0 ? void 0 : (_seriesConfig$metricO2 = seriesConfig.metricOptions) === null || _seriesConfig$metricO2 === void 0 ? void 0 : (_seriesConfig$metricO3 = _seriesConfig$metricO2.find(option => option.id === series.selectedMetricField || option.field === series.selectedMetricField)) === null || _seriesConfig$metricO3 === void 0 ? void 0 : _seriesConfig$metricO3.label) !== null && _seriesConfig$metricO !== void 0 ? _seriesConfig$metricO : series.selectedMetricField)) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })));
}
const SELECT_REPORT_METRIC_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.selectReportMetric', {
  defaultMessage: 'Select report metric'
});
const REMOVE_REPORT_METRIC_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.removeReportMetric', {
  defaultMessage: 'Remove report metric'
});
const NO_DATA_AVAILABLE = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.noData', {
  defaultMessage: 'No data available'
});
const NO_PERMISSIONS = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.noPermissions', {
  defaultMessage: "Unable to create Data View. You don't have the required permission, please contact your admin."
});
const REPORT_METRIC_TOOLTIP = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.reportMetricTooltip', {
  defaultMessage: 'Report metric'
});