"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateRangePicker = DateRangePicker;
exports.parseRelativeDate = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_series_storage = require("../hooks/use_series_storage");
var _constants = require("../configurations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/components/date_range_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parseRelativeDate = (date, options = {}) => {
  return _datemath.default.parse(date, options);
};
exports.parseRelativeDate = parseRelativeDate;
function DateRangePicker({
  seriesId,
  series
}) {
  var _series$time, _series$time2;
  const {
    firstSeries,
    setSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const seriesFrom = (_series$time = series.time) === null || _series$time === void 0 ? void 0 : _series$time.from;
  const seriesTo = (_series$time2 = series.time) === null || _series$time2 === void 0 ? void 0 : _series$time2.to;
  const {
    from: mainFrom,
    to: mainTo
  } = firstSeries.time;
  const startDate = parseRelativeDate(seriesFrom !== null && seriesFrom !== void 0 ? seriesFrom : mainFrom);
  const endDate = parseRelativeDate(seriesTo !== null && seriesTo !== void 0 ? seriesTo : mainTo, {
    roundUp: true
  });
  const getTotalDuration = () => {
    const mainStartDate = parseRelativeDate(mainFrom);
    const mainEndDate = parseRelativeDate(mainTo, {
      roundUp: true
    });
    return mainEndDate.diff(mainStartDate, 'millisecond');
  };
  const onStartChange = newStartDate => {
    if (reportType === _constants.ReportTypes.KPI) {
      const totalDuration = getTotalDuration();
      const newFrom = newStartDate.toISOString();
      const newTo = newStartDate.add(totalDuration, 'millisecond').toISOString();
      setSeries(seriesId, {
        ...series,
        time: {
          from: newFrom,
          to: newTo
        }
      });
    } else {
      const newFrom = newStartDate.toISOString();
      setSeries(seriesId, {
        ...series,
        time: {
          from: newFrom,
          to: seriesTo
        }
      });
    }
  };
  const onEndChange = newEndDate => {
    if (reportType === _constants.ReportTypes.KPI) {
      const totalDuration = getTotalDuration();
      const newTo = newEndDate.toISOString();
      const newFrom = newEndDate.subtract(totalDuration, 'millisecond').toISOString();
      setSeries(seriesId, {
        ...series,
        time: {
          from: newFrom,
          to: newTo
        }
      });
    } else {
      const newTo = newEndDate.toISOString();
      setSeries(seriesId, {
        ...series,
        time: {
          from: seriesFrom,
          to: newTo
        }
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    fullWidth: true,
    isCustom: true,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      fullWidth: true,
      selected: startDate,
      onChange: onStartChange,
      startDate: startDate,
      endDate: endDate,
      isInvalid: startDate > endDate,
      "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.dateRanger.startDate', {
        defaultMessage: 'Start date'
      }),
      dateFormat: dateFormat.replace('ss.SSS', 'ss'),
      showTimeSelect: true,
      popoverPlacement: "rightCenter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      fullWidth: true,
      showIcon: false,
      selected: endDate,
      onChange: onEndChange,
      startDate: startDate,
      endDate: endDate,
      isInvalid: startDate > endDate,
      "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.dateRanger.endDate', {
        defaultMessage: 'End date'
      }),
      dateFormat: dateFormat.replace('ss.SSS', 'ss'),
      showTimeSelect: true,
      popoverPlacement: "rightCenter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  });
}