"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapRecommendedQueriesFromExtensions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This function maps the recommended queries from the extensions to the autocomplete suggestions.
 * @param recommendedQueriesExtensions, the recommended queries extensions to map
 * @returns ISuggestionItem[], the mapped suggestions
 */
const mapRecommendedQueriesFromExtensions = recommendedQueriesExtensions => {
  const suggestions = recommendedQueriesExtensions.map(extension => {
    var _extension$name;
    return {
      label: extension.name,
      text: extension.query,
      detail: (_extension$name = extension.name) !== null && _extension$name !== void 0 ? _extension$name : '',
      ...(extension.description ? {
        documentation: {
          value: extension.description
        }
      } : {}),
      kind: 'Issue',
      sortText: 'D'
    };
  });
  return suggestions;
};
exports.mapRecommendedQueriesFromExtensions = mapRecommendedQueriesFromExtensions;