"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserNameOrId = exports.getUserFilter = exports.getSharedFilter = exports.getCombinedFilter = exports.getAdditionalFilter = exports.EMPTY_ALERT_ATTACK_DISCOVERY_USERS_KQL = exports.ALERT_ATTACK_DISCOVERY_USERS_NOT_EXISTS_KQL = void 0;
var _fp = require("lodash/fp");
var _field_names = require("../../schedules/fields/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** A KQL "users field is empty" query */
const EMPTY_ALERT_ATTACK_DISCOVERY_USERS_KQL = exports.EMPTY_ALERT_ATTACK_DISCOVERY_USERS_KQL = `${_field_names.ALERT_ATTACK_DISCOVERY_USERS}: ""`;

/** A KQL "users field does NOT exist" query */
const ALERT_ATTACK_DISCOVERY_USERS_NOT_EXISTS_KQL = exports.ALERT_ATTACK_DISCOVERY_USERS_NOT_EXISTS_KQL = `NOT ${_field_names.ALERT_ATTACK_DISCOVERY_USERS}: { name: * }`;
const getSharedFilter = shared => {
  if (shared === undefined) {
    // the shared filter will be applied after the user filter, joined with a leading `OR`
    return ` OR ${EMPTY_ALERT_ATTACK_DISCOVERY_USERS_KQL} OR ${ALERT_ATTACK_DISCOVERY_USERS_NOT_EXISTS_KQL}`;
  }

  // if shared is explicitly true, there won't be a leading `OR` to join with the user filter
  return shared ? `${EMPTY_ALERT_ATTACK_DISCOVERY_USERS_KQL} OR ${ALERT_ATTACK_DISCOVERY_USERS_NOT_EXISTS_KQL}` : ''; // shared is false, so no shared filter
};
exports.getSharedFilter = getSharedFilter;
const getUserNameOrId = authenticatedUser => !(0, _fp.isEmpty)(authenticatedUser.username) ? `name: "${authenticatedUser.username}"` : `id: "${authenticatedUser.profile_uid}"`;
exports.getUserNameOrId = getUserNameOrId;
const getUserFilter = ({
  authenticatedUser,
  shared
}) => {
  // If shared is (explicitly) true, we don't need to filter by user
  if (shared) {
    return '';
  }
  const userNameOrId = getUserNameOrId(authenticatedUser);
  return `${_field_names.ALERT_ATTACK_DISCOVERY_USERS}: { ${userNameOrId} }`;
};
exports.getUserFilter = getUserFilter;
const getAdditionalFilter = filter => filter != null && filter.trim().length > 0 ? ` AND ${filter}` : '';
exports.getAdditionalFilter = getAdditionalFilter;
const getCombinedFilter = ({
  authenticatedUser,
  filter,
  shared
}) => {
  const sharedFilter = getSharedFilter(shared);
  const userFilter = getUserFilter({
    authenticatedUser,
    shared
  });
  const additionalFilter = getAdditionalFilter(filter);
  return `(${userFilter}${sharedFilter})${additionalFilter}`;
};
exports.getCombinedFilter = getCombinedFilter;