"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _context_awareness = require("../../context_awareness");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/discover_grid/discover_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Customized version of the UnifiedDataTable
 * @constructor
 */
const DiscoverGrid = ({
  onUpdateESQLQuery,
  query,
  rowAdditionalLeadingControls: customRowAdditionalLeadingControls,
  ...props
}) => {
  const {
    dataView,
    setExpandedDoc,
    renderDocumentView
  } = props;
  const getRowIndicatorProvider = (0, _context_awareness.useProfileAccessor)('getRowIndicatorProvider');
  const getRowIndicator = (0, _react.useMemo)(() => {
    return getRowIndicatorProvider(() => undefined)({
      dataView: props.dataView
    });
  }, [getRowIndicatorProvider, props.dataView]);
  const getRowAdditionalLeadingControlsAccessor = (0, _context_awareness.useProfileAccessor)('getRowAdditionalLeadingControls');
  const rowAdditionalLeadingControls = (0, _react.useMemo)(() => {
    return getRowAdditionalLeadingControlsAccessor(() => customRowAdditionalLeadingControls)({
      actions: {
        updateESQLQuery: onUpdateESQLQuery,
        setExpandedDoc: renderDocumentView ? setExpandedDoc : undefined
      },
      dataView,
      query
    });
  }, [customRowAdditionalLeadingControls, dataView, getRowAdditionalLeadingControlsAccessor, onUpdateESQLQuery, query, setExpandedDoc, renderDocumentView]);
  const getPaginationConfigAccessor = (0, _context_awareness.useProfileAccessor)('getPaginationConfig');
  const paginationModeConfig = (0, _react.useMemo)(() => {
    return getPaginationConfigAccessor(() => ({
      paginationMode: _unifiedDataTable.DEFAULT_PAGINATION_MODE
    }))();
  }, [getPaginationConfigAccessor]);
  const getColumnsConfigurationAccessor = (0, _context_awareness.useProfileAccessor)('getColumnsConfiguration');
  const customGridColumnsConfiguration = (0, _react.useMemo)(() => {
    return getColumnsConfigurationAccessor(() => ({}))();
  }, [getColumnsConfigurationAccessor]);
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, (0, _extends2.default)({
    showColumnTokens: true,
    canDragAndDropColumns: true,
    enableComparisonMode: true,
    enableInTableSearch: true,
    renderCustomToolbar: _unifiedDataTable.renderCustomToolbar,
    getRowIndicator: getRowIndicator,
    rowAdditionalLeadingControls: rowAdditionalLeadingControls,
    visibleCellActions: 3 // this allows to show up to 3 actions on cell hover if available (filter in, filter out, and copy)
    ,
    paginationMode: paginationModeConfig.paginationMode,
    customGridColumnsConfiguration: customGridColumnsConfiguration,
    shouldKeepAdHocDataViewImmutable: true
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }));
};
exports.DiscoverGrid = DiscoverGrid;