"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitializationError = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _react = _interopRequireDefault(require("react"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _branded_loading_indicator = require("./branded_loading_indicator");
var _redux = require("../../state_management/redux");
var _error_alert = require("../../../../components/common/error_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/single_tab_view/initialization_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const InitializationError = ({
  error
}) => {
  if (error instanceof _public.SavedObjectNotFound) {
    return /*#__PURE__*/_react.default.createElement(RedirectWhenSavedObjectNotFound, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 10
    }
  });
};
exports.InitializationError = InitializationError;
const RedirectWhenSavedObjectNotFound = ({
  error
}) => {
  const {
    application: {
      navigateToApp
    },
    core,
    history,
    http: {
      basePath
    },
    toastNotifications,
    urlTracker
  } = (0, _use_discover_services.useDiscoverServices)();
  const discoverSessionId = (0, _redux.useInternalStateSelector)(state => {
    var _state$persistedDisco;
    return (_state$persistedDisco = state.persistedDiscoverSession) === null || _state$persistedDisco === void 0 ? void 0 : _state$persistedDisco.id;
  });
  (0, _useMount.default)(() => {
    const redirect = (0, _public.redirectWhenMissing)({
      history,
      navigateToApp,
      basePath,
      mapping: {
        search: '/',
        'index-pattern': {
          app: 'management',
          path: `kibana/objects/search/${discoverSessionId}`
        }
      },
      toastNotifications,
      onBeforeRedirect() {
        urlTracker.setTrackedUrl('/');
      },
      ...core
    });
    redirect(error);
  });
  return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 10
    }
  });
};