"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _default = require("../default/default");
var _samples = require("../../samples");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/duration/duration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DurationFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: [-123, 1, 12, 123, 658, 1988, 3857, 123292, 923528271],
      hasDecimalError: false
    });
  }
  static getDerivedStateFromProps(nextProps, state) {
    const output = super.getDerivedStateFromProps(nextProps, state);
    let error = null;
    const {
      outputPrecision
    } = nextProps.formatParams;
    if (!nextProps.format.isHuman() && outputPrecision != null && outputPrecision > 20) {
      error = _i18n.i18n.translate('indexPatternFieldEditor.durationErrorMessage', {
        defaultMessage: 'Decimal places must be between 0 and 20'
      });
      nextProps.onError(error);
      return {
        ...output,
        error,
        hasDecimalError: true
      };
    }
    return {
      ...output,
      hasDecimalError: false
    };
  }
  render() {
    var _formatParams$outputP;
    const {
      format
    } = this.props;
    const {
      error,
      samples,
      hasDecimalError
    } = this.state;
    const formatParams = {
      includeSpaceWithSuffix: format.getParamDefaults().includeSpaceWithSuffix,
      ...this.props.formatParams
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.inputFormatLabel",
        defaultMessage: "Input format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }),
      isInvalid: !!error,
      error: hasDecimalError ? null : error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": 'durationEditorInputFormat',
      value: formatParams.inputFormat,
      options: format.type.inputFormats.map(fmt => {
        return {
          value: fmt.kind,
          text: fmt.text
        };
      }),
      onChange: e => {
        this.onChange({
          inputFormat: e.target.value
        });
      },
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.outputFormatLabel",
        defaultMessage: "Output format",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 13
        }
      }),
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": 'durationEditorOutputFormat',
      value: formatParams.outputFormat,
      options: format.type.outputFormats.map(fmt => {
        return {
          value: fmt.method,
          text: fmt.text
        };
      }),
      onChange: e => {
        this.onChange({
          outputFormat: e.target.value
        });
      },
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    })), !format.isHuman() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.decimalPlacesLabel",
        defaultMessage: "Decimal places",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 17
        }
      }),
      isInvalid: !!error,
      error: hasDecimalError ? error : null,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: (_formatParams$outputP = formatParams.outputPrecision) !== null && _formatParams$outputP !== void 0 ? _formatParams$outputP : undefined,
      min: 0,
      max: 20,
      onChange: e => {
        this.onChange({
          outputPrecision: e.target.value ? Number(e.target.value) : null
        });
      },
      isInvalid: !!error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    })), !format.isHumanPrecise() && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.showSuffixLabel",
        defaultMessage: "Show suffix",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 21
        }
      }),
      checked: Boolean(formatParams.showSuffix),
      onChange: e => {
        this.onChange({
          showSuffix: !formatParams.showSuffix
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      disabled: !Boolean(formatParams.showSuffix) && !format.isHumanPrecise(),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.showSuffixLabel.short",
        defaultMessage: "Use short suffix",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 19
        }
      }),
      checked: Boolean(formatParams.useShortSuffix),
      onChange: e => {
        this.onChange({
          useShortSuffix: !formatParams.useShortSuffix
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      disabled: !Boolean(formatParams.showSuffix) && !format.isHumanPrecise(),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.duration.includeSpace",
        defaultMessage: "Include space between suffix and value",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 19
        }
      }),
      checked: Boolean(formatParams.includeSpaceWithSuffix),
      onChange: e => {
        this.onChange({
          includeSpaceWithSuffix: !formatParams.includeSpaceWithSuffix
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 15
      }
    }))) : null, /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }));
  }
}
exports.DurationFormatEditor = DurationFormatEditor;
(0, _defineProperty2.default)(DurationFormatEditor, "formatId", _constants.formatId);