"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueToComboBoxOption = exports.getNameFieldConfig = exports.getFieldPreviewChanges = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _form_schema = require("./form_schema");
var _constants = require("./constants");
var _types = require("../preview/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createNameNotAllowedValidator = (dataView, fieldName) => async ({
  value
}) => {
  const runtimeComposites = Object.entries(dataView.getAllRuntimeFields()).filter(([, _runtimeField]) => _runtimeField.type === 'composite').map(([_runtimeFieldName]) => _runtimeFieldName);
  if (value !== fieldName && (await dataView.getFieldByName(value, true))) {
    return {
      message: _i18n.i18n.translate('indexPatternFieldEditor.editor.runtimeFieldsEditor.existRuntimeFieldNamesValidationErrorMessage', {
        defaultMessage: 'A field with this name already exists.'
      })
    };
  } else if (value !== fieldName && runtimeComposites.includes(value)) {
    return {
      message: _i18n.i18n.translate('indexPatternFieldEditor.editor.runtimeFieldsEditor.existCompositeNamesValidationErrorMessage', {
        defaultMessage: 'A runtime composite with this name already exists.'
      })
    };
  }
};

/**
 * Dynamically retrieve the config for the "name" field, adding
 * a validator to avoid duplicated runtime fields to be created.
 *
 * @param field Initial value of the form
 */
const getNameFieldConfig = (dataView, field) => {
  var _nameFieldConfig$vali;
  const nameFieldConfig = _form_schema.schema.name;

  // Add validation to not allow duplicates
  return {
    ...nameFieldConfig,
    validations: [...((_nameFieldConfig$vali = nameFieldConfig.validations) !== null && _nameFieldConfig$vali !== void 0 ? _nameFieldConfig$vali : []), {
      validator: createNameNotAllowedValidator(dataView, field === null || field === void 0 ? void 0 : field.name)
    }]
  };
};
exports.getNameFieldConfig = getNameFieldConfig;
const valueToComboBoxOption = value => _constants.RUNTIME_FIELD_OPTIONS_PRIMITIVE.find(({
  value: optionValue
}) => optionValue === value);
exports.valueToComboBoxOption = valueToComboBoxOption;
const getFieldPreviewChanges = (subject, parentName) => subject.pipe((0, _rxjs.filter)(preview => preview !== undefined), (0, _rxjs.map)(items =>
// reduce the fields to make diffing easier
items.map(item => {
  const key = item.key.substring(`${parentName}.`.length);
  return {
    name: key,
    type: item.type
  };
})), (0, _rxjs.bufferCount)(2, 1),
// convert values into diff descriptions
(0, _rxjs.map)(([prev, next]) => {
  const changes = (0, _lodash.differenceWith)(next, prev, _lodash.isEqual).reduce((col, item) => {
    col[item.name] = {
      changeType: _types.ChangeType.UPSERT,
      type: item.type
    };
    return col;
  }, {});
  prev.forEach(prevItem => {
    if (!next.find(nextItem => nextItem.name === prevItem.name)) {
      changes[prevItem.name] = {
        changeType: _types.ChangeType.DELETE
      };
    }
  });
  return changes;
}), (0, _rxjs.filter)(fields => Object.keys(fields).length > 0));
exports.getFieldPreviewChanges = getFieldPreviewChanges;