"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDataCatalog = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataCatalogImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "dataTypes", new Map());
  }
  get(dataTypeId) {
    if (!this.dataTypes.has(dataTypeId)) {
      throw new Error(`Unknown data type: ${dataTypeId}`);
    }
    return this.dataTypes.get(dataTypeId);
  }
  list() {
    return [...this.dataTypes.values()];
  }
  register(dataType) {
    if (this.dataTypes.has(dataType.id)) {
      throw new Error(`Data type with id ${dataType.id} already registered`);
    }
    this.dataTypes.set(dataType.id, dataType);
  }
}
const createDataCatalog = () => {
  return new DataCatalogImpl();
};
exports.createDataCatalog = createDataCatalog;