"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFromLibrary = addFromLibrary;
var _react = _interopRequireDefault(require("react"));
var _presentationUtil = require("@kbn/presentation-util");
var _kibana_services = require("../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/add_panel_from_library.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
async function addFromLibrary(dashboardApi) {
  (0, _presentationUtil.openLazyFlyout)({
    core: _kibana_services.coreServices,
    parentApi: dashboardApi,
    loadContent: async ({
      ariaLabelledBy
    }) => {
      const Component = await _kibana_services.embeddableService.getAddFromLibraryComponent();
      return /*#__PURE__*/_react.default.createElement(Component, {
        container: dashboardApi,
        modalTitleId: ariaLabelledBy,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 20,
          columnNumber: 14
        }
      });
    },
    flyoutProps: {
      'data-test-subj': 'dashboardAddPanel',
      triggerId: 'dashboardAddTopNavButton'
    }
  });
}