"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownEmbeddableFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("./constants");
var _markdown_editor = require("./components/markdown_editor");
var _markdown_editor_preview_switch = require("./components/markdown_editor_preview_switch");
var _markdown_renderer = require("./components/markdown_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard_markdown/public/markdown_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const defaultMarkdownState = {
  content: ''
};
const markdownComparators = {
  content: 'referenceEquality'
};
const markdownEmbeddableFactory = exports.markdownEmbeddableFactory = {
  type: _constants.MARKDOWN_ID,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    parentApi,
    uuid
  }) => {
    const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
    const markdownStateManager = (0, _presentationPublishing.initializeStateManager)(initialState.rawState, defaultMarkdownState);
    const isEditing$ = new _rxjs.BehaviorSubject(false);
    const isNewPanel$ = new _rxjs.BehaviorSubject(false);
    const isPreview$ = new _rxjs.BehaviorSubject(false);
    const overrideHoverActions$ = new _rxjs.BehaviorSubject(false);
    const serializeState = () => ({
      rawState: {
        ...titleManager.getLatestState(),
        ...markdownStateManager.getLatestState()
      }
    });
    const resetEditingState = () => {
      isEditing$.next(false);
      overrideHoverActions$.next(false);
      isPreview$.next(false);
      if ((0, _presentationContainers.apiCanFocusPanel)(parentApi)) {
        parentApi.setFocusedPanelId();
      }
    };
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      serializeState,
      anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, markdownStateManager.anyStateChange$).pipe((0, _rxjs.map)(() => undefined)),
      getComparators: () => {
        return {
          ..._presentationPublishing.titleComparators,
          ...markdownComparators
        };
      },
      onReset: lastSaved => {
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        markdownStateManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
      }
    });
    const api = finalizeApi({
      ...unsavedChangesApi,
      ...titleManager.api,
      serializeState,
      onEdit: async ({
        isNewPanel = false
      } = {}) => {
        if (!(0, _presentationContainers.apiCanAddNewPanel)(parentApi)) throw new _public.IncompatibleActionError();
        isEditing$.next(true);
        overrideHoverActions$.next(true);
        if (isNewPanel !== isNewPanel$.getValue()) {
          isNewPanel$.next(isNewPanel);
        }
        if ((0, _presentationContainers.apiCanFocusPanel)(parentApi)) {
          parentApi.setFocusedPanelId(api.uuid);
        }
      },
      isEditingEnabled: () => true,
      getTypeDisplayName: () => 'Markdown',
      overrideHoverActions$,
      OverriddenHoverActionsComponent: () => /*#__PURE__*/_react.default.createElement(_markdown_editor_preview_switch.MarkdownEditorPreviewSwitch, {
        isPreview$: isPreview$,
        isEditing$: isEditing$,
        onSwitch: isPreview => {
          isPreview$.next(isPreview);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 9
        }
      })
    });
    return {
      api,
      Component: function MarkdownEmbeddableComponent() {
        var _getViewModeSubject, _processingPluginList, _processingPluginList2, _processingPluginList3;
        const [content, isEditing, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(markdownStateManager.api.content$, isEditing$, (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(api)) !== null && _getViewModeSubject !== void 0 ? _getViewModeSubject : new _rxjs.BehaviorSubject('view'));
        const {
          processingPlugins: processingPluginList,
          uiPlugins
        } = (0, _eui.getDefaultEuiMarkdownPlugins)();

        // openLinksInNewTab functionality from src/platform/packages/shared/shared-ux/markdown/impl/markdown.tsx
        if ((_processingPluginList = processingPluginList[1]) !== null && _processingPluginList !== void 0 && (_processingPluginList2 = _processingPluginList[1]) !== null && _processingPluginList2 !== void 0 && (_processingPluginList3 = _processingPluginList2.components) !== null && _processingPluginList3 !== void 0 && _processingPluginList3.a) {
          processingPluginList[1][1].components.a = props => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, props, {
            target: "_blank",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 13
            }
          }));
        }
        if (viewMode === 'view' || !isEditing) {
          return /*#__PURE__*/_react.default.createElement(_markdown_renderer.MarkdownRenderer, {
            processingPluginList: processingPluginList,
            content: content,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 144,
              columnNumber: 18
            }
          });
        }
        return /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownEditor, {
          uiPlugins: uiPlugins,
          processingPluginList: processingPluginList,
          content: content,
          onCancel: () => {
            if (isNewPanel$.getValue() && (0, _presentationContainers.apiIsPresentationContainer)(parentApi)) {
              parentApi.removePanel(api.uuid);
            }
            resetEditingState();
          },
          onSave: value => {
            resetEditingState();
            markdownStateManager.api.setContent(value);
            if (isNewPanel$.getValue()) {
              isNewPanel$.next(false);
            }
          },
          isPreview$: isPreview$,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 11
          }
        });
      }
    };
  }
};