"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadHttp = loadHttp;
var _coreDiServer = require("@kbn/core-di-server");
var _coreDiInternal = require("@kbn/core-di-internal");
var _coreDi = require("@kbn/core-di");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function loadHttp({
  bind,
  onActivation
}) {
  onActivation(_coreDiServer.Route, ({
    get
  }, route) => {
    const router = get(_coreDiServer.Router);
    const register = router[route.method];
    let handler = async (_context, request, response) => {
      const scope = get((0, _coreDiServer.CoreStart)('injection')).fork();
      scope.bind(_coreDiServer.Request).toConstantValue(request);
      scope.bind(_coreDiServer.Response).toConstantValue(response);
      scope.bind(_coreDiInternal.Global).toConstantValue(_coreDiServer.Request);
      scope.bind(_coreDiInternal.Global).toConstantValue(_coreDiServer.Response);
      try {
        return await scope.get(route, {
          autobind: true
        }).handle();
      } finally {
        scope.unbindAll();
      }
    };
    if (route.handleLegacyErrors) {
      handler = router.handleLegacyErrors(handler);
    }
    register(route, handler);
    return route;
  });
  bind(_coreDiServer.Router).toResolvedValue(httpSetup => httpSetup.createRouter(), [(0, _coreDiServer.CoreSetup)('http')]).inRequestScope().onActivation((0, _coreDiInternal.cacheInScope)(_coreDiServer.Router));
  bind(_coreDi.OnSetup).toConstantValue(container => {
    container.getAll(_coreDiServer.Route);
  });
}