"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadLogging = loadLogging;
var _coreDi = require("@kbn/core-di");
var _utils = require("../utils");
var _lifecycle = require("./lifecycle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function loadLogging({
  bind
}) {
  bind(_coreDi.Logger).toResolvedValue(factory => factory.get(), [_coreDi.LoggerFactory]).inRequestScope().onActivation((0, _utils.cacheInScope)(_coreDi.Logger));
  bind(_coreDi.LoggerFactory).toService((0, _lifecycle.InternalPluginInitializer)('logger'));
}