"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _rxjs = require("rxjs");
var _url = require("url");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _recentlyAccessed = require("@kbn/recently-accessed");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _printing_observable = require("./utils/printing_observable");
var _doc_title = require("./doc_title");
var _nav_controls = require("./nav_controls");
var _nav_links = require("./nav_links");
var _project_navigation = require("./project_navigation");
var _ui = require("./ui");
var _register_analytics_context_provider = require("./register_analytics_context_provider");
var _header_top_banner = require("./ui/header/header_top_banner");
var _handle_system_colormode_change = require("./handle_system_colormode_change");
var _app_menu = require("./ui/project/app_menu");
var _sidenav = require("./ui/project/sidenav_v1/sidenav");
var _grid_layout_sidenav = require("./ui/project/sidenav_v2/grid_layout_sidenav");
var _fixed_layout_sidenav = require("./ui/project/sidenav_v2/fixed_layout_sidenav");
var _collapse_button = require("./ui/project/sidenav_v2/collapse_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/chrome_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const IS_SIDENAV_COLLAPSED_KEY = 'core.chrome.isSideNavCollapsed';
const SNAPSHOT_REGEX = /-snapshot/i;
/** @internal */
class ChromeService {
  constructor(params) {
    (0, _defineProperty2.default)(this, "isVisible$", void 0);
    (0, _defineProperty2.default)(this, "isForceHidden$", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "navControls", new _nav_controls.NavControlsService());
    (0, _defineProperty2.default)(this, "navLinks", new _nav_links.NavLinksService());
    (0, _defineProperty2.default)(this, "recentlyAccessed", new _recentlyAccessed.RecentlyAccessedService());
    (0, _defineProperty2.default)(this, "docTitle", new _doc_title.DocTitleService());
    (0, _defineProperty2.default)(this, "projectNavigation", void 0);
    (0, _defineProperty2.default)(this, "mutationObserver", void 0);
    (0, _defineProperty2.default)(this, "isSideNavCollapsed$", new _rxjs.BehaviorSubject(localStorage.getItem(IS_SIDENAV_COLLAPSED_KEY) === 'true'));
    (0, _defineProperty2.default)(this, "isFeedbackBtnVisible$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isServerless", false);
    (0, _defineProperty2.default)(this, "setIsVisible", isVisible => this.isForceHidden$.next(!isVisible));
    /**
     * Some EUI component can be toggled in Full screen (e.g. the EuiDataGrid). When they are toggled in full
     * screen we want to hide the chrome, and when they are toggled back to normal we want to show the chrome.
     */
    (0, _defineProperty2.default)(this, "handleEuiFullScreenChanges", () => {
      const {
        body
      } = document;
      // HTML class names that are added to the body when Eui components are toggled in full screen
      const classesOnBodyWhenEuiFullScreen = ['euiDataGrid__restrictBody'];
      let isChromeHiddenForEuiFullScreen = false;
      let isChromeVisible = false;
      this.isVisible$.pipe((0, _rxjs.takeUntil)(this.stop$)).subscribe(isVisible => {
        isChromeVisible = isVisible;
      });
      const onBodyClassesChange = () => {
        const {
          className
        } = body;
        if (classesOnBodyWhenEuiFullScreen.some(name => className.includes(name)) && isChromeVisible) {
          isChromeHiddenForEuiFullScreen = true;
          this.setIsVisible(false);
        } else if (classesOnBodyWhenEuiFullScreen.every(name => !className.includes(name)) && !isChromeVisible && isChromeHiddenForEuiFullScreen) {
          isChromeHiddenForEuiFullScreen = false;
          this.setIsVisible(true);
        }
      };
      this.mutationObserver = new MutationObserver(mutationList => {
        mutationList.forEach(mutation => {
          if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
            onBodyClassesChange();
          }
        });
      });
      this.mutationObserver.observe(body, {
        attributes: true
      });
    });
    // Ensure developers are notified if working in a context that lacks the EUI Provider.
    // @ts-expect-error
    (0, _defineProperty2.default)(this, "handleEuiDevProviderWarning", notifications => {
      const isDev = this.params.coreContext.env.mode.name === 'development';
      if (isDev) {
        (0, _eui.setEuiDevProviderWarning)(providerError => {
          var _errorObject$stack;
          const errorObject = new Error(providerError.toString());
          // 1. show a stack trace in the console
          // eslint-disable-next-line no-console
          console.error(errorObject);

          // 2. store error in sessionStorage so it can be detected in testing
          const storedError = {
            message: providerError.toString(),
            stack: (_errorObject$stack = errorObject.stack) !== null && _errorObject$stack !== void 0 ? _errorObject$stack : 'undefined',
            pageHref: window.location.href,
            pageTitle: document.title
          };
          sessionStorage.setItem('dev.euiProviderWarning', JSON.stringify(storedError));

          // 3. error toast / popup
          notifications.toasts.addDanger({
            title: '`EuiProvider` is missing',
            text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement("p", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 233,
                columnNumber: 13
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "core.chrome.euiDevProviderWarning",
              defaultMessage: "Kibana components must be wrapped in a React Context provider for full functionality and proper theming support. See {link}.",
              values: {
                link: /*#__PURE__*/_react.default.createElement("a", {
                  href: "https://docs.elastic.dev/kibana-dev-docs/react-context",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 239,
                    columnNumber: 21
                  }
                }, "https://docs.elastic.dev/kibana-dev-docs/react-context")
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 234,
                columnNumber: 15
              }
            }))),
            'data-test-subj': 'core-chrome-euiDevProviderWarning-toast',
            toastLifeTimeMs: 60 * 60 * 1000 // keep message visible for up to an hour
          });
        });
      }
    });
    this.params = params;
    this.logger = params.coreContext.logger.get('chrome-browser');
    this.isServerless = params.coreContext.env.packageInfo.buildFlavor === 'serverless';
    this.projectNavigation = new _project_navigation.ProjectNavigationService(this.isServerless);
  }

  /**
   * These observables allow consumers to toggle the chrome visibility via either:
   *   1. Using setIsVisible() to trigger the next chromeHidden$
   *   2. Setting `chromeless` when registering an application, which will
   *      reset the visibility whenever the next application is mounted
   *   3. Having "embed" in the query string
   */
  initVisibility(application) {
    // Start off the chrome service hidden if "embed" is in the hash query string.
    const isEmbedded = 'embed' in (0, _url.parse)(location.hash.slice(1), true).query;
    this.isForceHidden$ = new _rxjs.BehaviorSubject(isEmbedded);
    const appHidden$ = (0, _rxjs.merge)(
    // For the isVisible$ logic, having no mounted app is equivalent to having a hidden app
    // in the sense that the chrome UI should not be displayed until a non-chromeless app is mounting or mounted
    (0, _rxjs.of)(true), application.currentAppId$.pipe((0, _rxjs.mergeMap)(appId => application.applications$.pipe((0, _rxjs.map)(applications => {
      return !!appId && applications.has(appId) && !!applications.get(appId).chromeless;
    })))));
    this.isVisible$ = (0, _rxjs.combineLatest)([appHidden$, this.isForceHidden$, _printing_observable.isPrinting$]).pipe((0, _rxjs.map)(([appHidden, forceHidden, isPrinting]) => !appHidden && !forceHidden && !isPrinting), (0, _rxjs.takeUntil)(this.stop$));
  }
  setup({
    analytics
  }) {
    const docTitle = this.docTitle.setup({
      document: window.document
    });
    (0, _register_analytics_context_provider.registerAnalyticsContextProvider)(analytics, docTitle.title$);
  }
  async start({
    application,
    docLinks,
    http,
    injectedMetadata,
    notifications,
    customBranding,
    i18n: i18nService,
    theme,
    userProfile,
    uiSettings,
    analytics,
    featureFlags
  }) {
    this.initVisibility(application);
    this.handleEuiFullScreenChanges();
    (0, _handle_system_colormode_change.handleSystemColorModeChange)({
      notifications,
      coreStart: {
        i18n: i18nService,
        theme,
        userProfile
      },
      stop$: this.stop$,
      http,
      uiSettings
    });
    // commented out until https://github.com/elastic/kibana/issues/201805 can be fixed
    // this.handleEuiDevProviderWarning(notifications);

    const globalHelpExtensionMenuLinks$ = new _rxjs.BehaviorSubject([]);
    const helpExtension$ = new _rxjs.BehaviorSubject(undefined);
    const breadcrumbs$ = new _rxjs.BehaviorSubject([]);
    const breadcrumbsAppendExtensions$ = new _rxjs.BehaviorSubject([]);
    const badge$ = new _rxjs.BehaviorSubject(undefined);
    const customNavLink$ = new _rxjs.BehaviorSubject(undefined);
    const helpSupportUrl$ = new _rxjs.BehaviorSubject(docLinks.links.kibana.askElastic);
    // ChromeStyle is set to undefined by default, which means that no header will be rendered until
    // setChromeStyle(). This is to avoid a flickering between the "classic" and "project" header meanwhile
    // we load the user profile to check if the user opted out of the new solution navigation.
    const chromeStyleSubject$ = new _rxjs.BehaviorSubject(undefined);
    const getKbnVersionClass = () => {
      // we assume that the version is valid and has the form 'X.X.X'
      // strip out `SNAPSHOT` and reformat to 'X-X-X'
      const formattedVersionClass = this.params.kibanaVersion.replace(SNAPSHOT_REGEX, '').split('.').join('-');
      return `kbnVersion-${formattedVersionClass}`;
    };
    const chromeStyle$ = chromeStyleSubject$.pipe((0, _rxjs.filter)(style => style !== undefined), (0, _rxjs.takeUntil)(this.stop$));
    const setChromeStyle = style => {
      if (style === chromeStyleSubject$.getValue()) return;
      chromeStyleSubject$.next(style);
    };
    const headerBanner$ = new _rxjs.BehaviorSubject(undefined);
    const bodyClasses$ = (0, _rxjs.combineLatest)([headerBanner$, this.isVisible$, chromeStyleSubject$, application.currentActionMenu$]).pipe((0, _rxjs.map)(([headerBanner, isVisible, chromeStyle, actionMenu]) => {
      return ['kbnBody', headerBanner ? 'kbnBody--hasHeaderBanner' : 'kbnBody--noHeaderBanner', isVisible ? 'kbnBody--chromeVisible' : 'kbnBody--chromeHidden', chromeStyle === 'project' && actionMenu ? 'kbnBody--hasProjectActionMenu' : '', getKbnVersionClass()].filter(className => !!className);
    }));
    const navControls = this.navControls.start();
    const navLinks = this.navLinks.start({
      application,
      http
    });
    const projectNavigation = this.projectNavigation.start({
      application,
      navLinksService: navLinks,
      http,
      chromeBreadcrumbs$: breadcrumbs$,
      logger: this.logger,
      featureFlags
    });
    const recentlyAccessed = this.recentlyAccessed.start({
      http,
      key: 'recentlyAccessed'
    });
    const docTitle = this.docTitle.start();
    const {
      customBranding$
    } = customBranding;
    const helpMenuLinks$ = navControls.getHelpMenuLinks$();

    // erase chrome fields from a previous app while switching to a next app
    application.currentAppId$.subscribe(() => {
      helpExtension$.next(undefined);
      breadcrumbs$.next([]);
      badge$.next(undefined);
      docTitle.reset();
    });
    const validateChromeStyle = () => {
      const chromeStyle = chromeStyleSubject$.getValue();
      if (chromeStyle !== 'project') {
        // Helps ensure callers go through the serverless plugin to get here.
        throw new Error(`Invalid ChromeStyle value of "${chromeStyle}". This method requires ChromeStyle set to "project".`);
      }
    };
    function initProjectNavigation(id, navigationTree$, config) {
      validateChromeStyle();
      projectNavigation.initNavigation(id, navigationTree$, config);
    }
    const setProjectBreadcrumbs = (breadcrumbs, params) => {
      projectNavigation.setProjectBreadcrumbs(breadcrumbs, params);
    };
    const setClassicBreadcrumbs = (newBreadcrumbs, {
      project
    } = {}) => {
      breadcrumbs$.next(newBreadcrumbs);
      if (project) {
        const {
          value: projectValue,
          absolute = false
        } = project;
        setProjectBreadcrumbs(projectValue !== null && projectValue !== void 0 ? projectValue : [], {
          absolute
        });
      }
    };
    const setProjectHome = homeHref => {
      validateChromeStyle();
      projectNavigation.setProjectHome(homeHref);
    };
    const setProjectName = projectName => {
      validateChromeStyle();
      projectNavigation.setProjectName(projectName);
    };
    const setIsSideNavCollapsed = isCollapsed => {
      localStorage.setItem(IS_SIDENAV_COLLAPSED_KEY, JSON.stringify(isCollapsed));
      this.isSideNavCollapsed$.next(isCollapsed);
    };
    if (!this.params.browserSupportsCsp && injectedMetadata.getCspConfig().warnLegacyBrowsers) {
      notifications.toasts.addWarning({
        title: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "core.chrome.legacyBrowserWarning",
          defaultMessage: "Your browser does not meet the security requirements for Kibana.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 421,
            columnNumber: 11
          }
        }))
      });
    }

    /**
     * Classic header is a header for the "classic" navigation with all solutions
     * It can be customized to be used with either legacy fixed layout or new grid layout.
     * In fixed layout it is fixed to the top of the page, with display: fixed; and should be responsible for rendering the banner
     *
     * @param isFixed
     * @param includeBanner
     */
    const getClassicHeader = ({
      isFixed,
      includeBanner
    }) => /*#__PURE__*/_react.default.createElement(_ui.Header
    /* customizable header variations */, {
      headerBanner$: includeBanner ? headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)) : null,
      isFixed: isFixed
      /* consistent header properties */,
      isServerless: this.isServerless,
      loadingCount$: http.getLoadingCount$(),
      application: application,
      badge$: badge$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      basePath: http.basePath,
      breadcrumbs$: breadcrumbs$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      customNavLink$: customNavLink$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      kibanaDocLink: docLinks.links.kibana.guide,
      docLinks: docLinks,
      forceAppSwitcherNavigation$: navLinks.getForceAppSwitcherNavigation$(),
      globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
      helpExtension$: helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      helpSupportUrl$: helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      helpMenuLinks$: helpMenuLinks$,
      homeHref: http.basePath.prepend('/app/home'),
      kibanaVersion: injectedMetadata.getKibanaVersion(),
      navLinks$: navLinks.getNavLinks$(),
      recentlyAccessed$: recentlyAccessed.get$(),
      navControlsLeft$: navControls.getLeft$(),
      navControlsCenter$: navControls.getCenter$(),
      navControlsRight$: navControls.getRight$(),
      navControlsExtension$: navControls.getExtension$(),
      customBranding$: customBranding$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 7
      }
    });

    // create observables once here to avoid re-renders, TODO: do it for everything else
    const navLinks$ = navLinks.getNavLinks$();
    const activeNodes$ = projectNavigation.getActiveNodes$();
    const navigationTreeUi$ = projectNavigation.getNavigationTreeUi$();
    const panelSelectedNode$ = projectNavigation.getPanelSelectedNode$();
    const loadingCount$ = http.getLoadingCount$();
    const recentlyAccessed$ = recentlyAccessed.get$();
    const activeDataTestSubj$ = projectNavigation.getActiveDataTestSubj$();
    const feedbackUrlParams$ = projectNavigation.getFeedbackUrlParams$();
    const navProps = {
      basePath: http.basePath,
      application,
      reportEvent: analytics.reportEvent,
      navigationTree$: navigationTreeUi$,
      activeNodes$,
      navLinks$,
      recentlyAccessed$,
      loadingCount$,
      dataTestSubj$: activeDataTestSubj$,
      isFeedbackBtnVisible$: this.isFeedbackBtnVisible$,
      navigationTourManager: projectNavigation.tourManager,
      feedbackUrlParams$
    };
    const getProjectHeader = ({
      includeSideNav,
      isFixed,
      includeBanner,
      includeAppMenu
    }) => /*#__PURE__*/_react.default.createElement(_ui.ProjectHeader, {
      isServerless: this.isServerless,
      isFixed: isFixed,
      application: application,
      globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
      actionMenu$: includeAppMenu ? application.currentActionMenu$ : null,
      breadcrumbs$: projectNavigation.getProjectBreadcrumbs$().pipe((0, _rxjs.takeUntil)(this.stop$)),
      breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      customBranding$: customBranding$,
      helpExtension$: helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      helpSupportUrl$: helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      helpMenuLinks$: helpMenuLinks$,
      navControlsLeft$: navControls.getLeft$(),
      navControlsCenter$: navControls.getCenter$(),
      navControlsRight$: navControls.getRight$(),
      loadingCount$: http.getLoadingCount$(),
      headerBanner$: includeBanner ? headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)) : null,
      homeHref$: projectNavigation.getProjectHome$(),
      docLinks: docLinks,
      kibanaVersion: injectedMetadata.getKibanaVersion(),
      prependBasePath: http.basePath.prepend,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 534,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: application.history,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 556,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (includeSideNav === 'v1' || includeSideNav === 'both') && /*#__PURE__*/_react.default.createElement(_sidenav.ProjectSideNavV1, {
      isCollapsed$: this.isSideNavCollapsed$,
      toggle: setIsSideNavCollapsed,
      navigationTree$: navigationTreeUi$,
      navigateToUrl: application.navigateToUrl,
      navLinks$: navLinks$,
      activeNodes$: activeNodes$,
      recentlyAccessed$: recentlyAccessed$,
      basePath: http.basePath,
      isFeedbackBtnVisible$: this.isFeedbackBtnVisible$,
      panelSelectedNode$: panelSelectedNode$,
      setPanelSelectedNode: projectNavigation.setPanelSelectedNode,
      loadingCount$: loadingCount$,
      reportEvent: analytics.reportEvent,
      dataTestSubj$: activeDataTestSubj$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 559,
        columnNumber: 15
      }
    }), (includeSideNav === 'v2' || includeSideNav === 'both') && /*#__PURE__*/_react.default.createElement(_fixed_layout_sidenav.FixedLayoutProjectSideNavV2, {
      isCollapsed$: this.isSideNavCollapsed$,
      toggle: setIsSideNavCollapsed,
      navProps: navProps,
      side: includeSideNav === 'both' ? 'right' : 'left',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 578,
        columnNumber: 15
      }
    }))), !includeSideNav && /*#__PURE__*/_react.default.createElement(_collapse_button.SideNavV2CollapseButton, {
      isCollapsed: this.isSideNavCollapsed$,
      toggle: setIsSideNavCollapsed,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 590,
        columnNumber: 11
      }
    }));
    const getLegacyHeaderComponentForFixedLayout = ({
      projectSideNavVersion
    } = {
      projectSideNavVersion: 'v1'
    }) => {
      const defaultChromeStyle = chromeStyleSubject$.getValue();
      const HeaderComponent = () => {
        // TODO: remove useObservable usage https://github.com/elastic/kibana/issues/225265
        const isVisible = (0, _useObservable.default)(this.isVisible$);
        const chromeStyle = (0, _useObservable.default)(chromeStyle$, defaultChromeStyle);
        if (!isVisible) {
          return /*#__PURE__*/_react.default.createElement("div", {
            "data-test-subj": "kibanaHeaderChromeless",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 614,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_ui.LoadingIndicator, {
            loadingCount$: http.getLoadingCount$(),
            showAsBar: true,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 615,
              columnNumber: 15
            }
          }), /*#__PURE__*/_react.default.createElement(_header_top_banner.HeaderTopBanner, {
            headerBanner$: headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 616,
              columnNumber: 15
            }
          }));
        }
        if (chromeStyle === undefined) return null;

        // render header
        if (chromeStyle === 'project') {
          return getProjectHeader({
            isFixed: true,
            includeBanner: true,
            includeSideNav: projectSideNavVersion,
            includeAppMenu: true
          });
        }
        return getClassicHeader({
          isFixed: true,
          includeBanner: true
        });
      };
      return /*#__PURE__*/_react.default.createElement(HeaderComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 636,
          columnNumber: 14
        }
      });
    };
    const getClassicHeaderComponentForGridLayout = () => {
      return getClassicHeader({
        isFixed: false,
        includeBanner: false
      });
    };
    const getProjectHeaderComponentForGridLayout = ({
      includeSideNav
    }) => {
      return getProjectHeader({
        includeSideNav,
        // in grid layout the header is not fixed, but is inside grid's layout header cell
        isFixed: false,
        // in grid layout the layout is responsible for rendering the banner
        includeBanner: false,
        // in grid layout the application subheader is rendered by the layout service as part of the application slot
        includeAppMenu: false
      });
    };
    const getProjectSideNavV2ComponentForGridLayout = () => {
      return /*#__PURE__*/_react.default.createElement(_grid_layout_sidenav.GridLayoutProjectSideNavV2, {
        isCollapsed$: this.isSideNavCollapsed$,
        navProps: navProps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 661,
          columnNumber: 9
        }
      });
    };
    return {
      // TODO: this service does too much and doesn't have to compose these headers components.
      // let's get rid of this in the future https://github.com/elastic/kibana/issues/225264
      getLegacyHeaderComponentForFixedLayout,
      getClassicHeaderComponentForGridLayout,
      getProjectHeaderComponentForGridLayout,
      getProjectSideNavV2ComponentForGridLayout,
      getHeaderBanner: () => {
        return /*#__PURE__*/_react.default.createElement(_header_top_banner.HeaderTopBanner, {
          headerBanner$: headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          position: 'static',
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 674,
            columnNumber: 11
          }
        });
      },
      getChromelessHeader: () => {
        return /*#__PURE__*/_react.default.createElement("div", {
          "data-test-subj": "kibanaHeaderChromeless",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 682,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_ui.LoadingIndicator, {
          loadingCount$: http.getLoadingCount$(),
          showAsBar: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 683,
            columnNumber: 13
          }
        }));
      },
      getProjectAppMenuComponent: () => {
        return /*#__PURE__*/_react.default.createElement(_app_menu.AppMenuBar, {
          appMenuActions$: application.currentActionMenu$,
          isFixed: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 688,
            columnNumber: 16
          }
        });
      },
      // chrome APIs
      navControls,
      navLinks,
      recentlyAccessed,
      docTitle,
      getIsVisible$: () => this.isVisible$,
      setIsVisible: this.setIsVisible.bind(this),
      getBadge$: () => badge$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBadge: badge => {
        badge$.next(badge);
      },
      getBreadcrumbs$: () => breadcrumbs$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBreadcrumbs: setClassicBreadcrumbs,
      getBreadcrumbsAppendExtensions$: () => breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBreadcrumbsAppendExtension: breadcrumbsAppendExtension => {
        breadcrumbsAppendExtensions$.next([...breadcrumbsAppendExtensions$.getValue(), breadcrumbsAppendExtension].sort(({
          order: orderA = 50
        }, {
          order: orderB = 50
        }) => orderA - orderB));
        return () => {
          breadcrumbsAppendExtensions$.next(breadcrumbsAppendExtensions$.getValue().filter(ext => ext !== breadcrumbsAppendExtension));
        };
      },
      getGlobalHelpExtensionMenuLinks$: () => globalHelpExtensionMenuLinks$.asObservable(),
      registerGlobalHelpExtensionMenuLink: globalHelpExtensionMenuLink => {
        globalHelpExtensionMenuLinks$.next([...globalHelpExtensionMenuLinks$.value, globalHelpExtensionMenuLink]);
      },
      getHelpExtension$: () => helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setHelpExtension: helpExtension => {
        helpExtension$.next(helpExtension);
      },
      setHelpSupportUrl: url => helpSupportUrl$.next(url),
      getHelpSupportUrl$: () => helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      getCustomNavLink$: () => customNavLink$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setCustomNavLink: customNavLink => {
        customNavLink$.next(customNavLink);
      },
      setHelpMenuLinks: helpMenuLinks => {
        navControls.setHelpMenuLinks(helpMenuLinks);
      },
      setHeaderBanner: headerBanner => {
        headerBanner$.next(headerBanner);
      },
      hasHeaderBanner$: () => {
        return headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.map)(banner => Boolean(banner)));
      },
      getBodyClasses$: () => bodyClasses$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setChromeStyle,
      getChromeStyle$: () => chromeStyle$,
      sideNav: {
        getIsCollapsed$: () => this.isSideNavCollapsed$.asObservable(),
        setIsCollapsed: setIsSideNavCollapsed,
        getPanelSelectedNode$: projectNavigation.getPanelSelectedNode$.bind(projectNavigation),
        setPanelSelectedNode: projectNavigation.setPanelSelectedNode.bind(projectNavigation),
        getIsFeedbackBtnVisible$: () => (0, _rxjs.combineLatest)([this.isFeedbackBtnVisible$, this.isSideNavCollapsed$]).pipe((0, _rxjs.map)(([isVisible, isCollapsed]) => isVisible && !isCollapsed)),
        setIsFeedbackBtnVisible: isVisible => this.isFeedbackBtnVisible$.next(isVisible)
      },
      getActiveSolutionNavId$: () => projectNavigation.getActiveSolutionNavId$(),
      project: {
        setHome: setProjectHome,
        setCloudUrls: projectNavigation.setCloudUrls.bind(projectNavigation),
        setFeedbackUrlParams: projectNavigation.setFeedbackUrlParams.bind(projectNavigation),
        setProjectName,
        initNavigation: initProjectNavigation,
        getNavigationTreeUi$: () => projectNavigation.getNavigationTreeUi$(),
        setBreadcrumbs: setProjectBreadcrumbs,
        getBreadcrumbs$: projectNavigation.getProjectBreadcrumbs$.bind(projectNavigation),
        getActiveNavigationNodes$: () => projectNavigation.getActiveNodes$(),
        updateSolutionNavigations: projectNavigation.updateSolutionNavigations,
        changeActiveSolutionNavigation: projectNavigation.changeActiveSolutionNavigation,
        navigationTourManager: projectNavigation.tourManager
      }
    };
  }
  stop() {
    var _this$mutationObserve;
    this.navLinks.stop();
    this.projectNavigation.stop();
    this.stop$.next();
    (_this$mutationObserve = this.mutationObserver) === null || _this$mutationObserve === void 0 ? void 0 : _this$mutationObserve.disconnect();
  }
}
exports.ChromeService = ChromeService;