"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForTask = void 0;
var Either = _interopRequireWildcard(require("fp-ts/Either"));
var Option = _interopRequireWildcard(require("fp-ts/Option"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/**
 * After waiting for the specified timeout, the task has not yet completed.
 *
 * When querying the tasks API we use `wait_for_completion=true` to block the
 * request until the task completes. If after the `timeout`, the task still has
 * not completed we return this error. This does not mean that the task itelf
 * has reached a timeout, Elasticsearch will continue to run the task.
 */

/**
 * When we use `wait_for_completion=false`, we won't get the errors right away, we'll get a
 * task id. Then we have to query the tasks API with that id and Elasticsearch will tell us
 * if there was any error in the original task inside a 200 response. In some cases we might
 * want to retry the original task.
 */

const catchWaitForTaskCompletionTimeout = e => {
  var _e$body, _e$body$error, _e$body2, _e$body2$error;
  if (((_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$error = _e$body.error) === null || _e$body$error === void 0 ? void 0 : _e$body$error.type) === 'timeout_exception' || ((_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : (_e$body2$error = _e$body2.error) === null || _e$body2$error === void 0 ? void 0 : _e$body2$error.type) === 'receive_timeout_transport_exception') {
    return Either.left({
      type: 'wait_for_task_completion_timeout',
      message: `[${e.body.error.type}] ${e.body.error.reason}`,
      error: e
    });
  } else {
    throw e;
  }
};

/** @internal */

/**
 * Blocks for up to 60s or until a task completes.
 *
 * TODO: delete completed tasks
 */
const waitForTask = ({
  client,
  taskId,
  timeout
}) => () => {
  return client.tasks.get({
    task_id: taskId,
    wait_for_completion: true,
    timeout
  }).then(body => {
    var _body$response$failur, _body$response;
    const failures = (_body$response$failur = (_body$response = body.response) === null || _body$response === void 0 ? void 0 : _body$response.failures) !== null && _body$response$failur !== void 0 ? _body$response$failur : [];
    return Either.right({
      completed: body.completed,
      error: Option.fromNullable(body.error),
      failures: failures.length > 0 ? Option.some(failures) : Option.none,
      description: body.task.description,
      response: body.response
    });
  }).catch(catchWaitForTaskCompletionTimeout).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.waitForTask = waitForTask;